/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.transform;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public abstract class TransformerObjectSupport {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private TransformerFactory transformerFactory;
    private Class transformerFactoryClass;

    public void setTransformerFactoryClass(Class transformerFactoryClass) {
        Assert.isAssignable((Class)TransformerFactory.class, (Class)transformerFactoryClass);
        this.transformerFactoryClass = transformerFactoryClass;
    }

    protected TransformerFactory newTransformerFactory(Class transformerFactoryClass) {
        if (transformerFactoryClass != null) {
            try {
                return (TransformerFactory)transformerFactoryClass.newInstance();
            }
            catch (Exception ex) {
                throw new TransformerFactoryConfigurationError(ex, "Could not instantiate TransformerFactory");
            }
        }
        return TransformerFactory.newInstance();
    }

    protected TransformerFactory getTransformerFactory() {
        if (this.transformerFactory == null) {
            this.transformerFactory = this.newTransformerFactory(this.transformerFactoryClass);
        }
        return this.transformerFactory;
    }

    protected final Transformer createTransformer() throws TransformerConfigurationException {
        return this.getTransformerFactory().newTransformer();
    }

    protected final void transform(Source source, Result result) throws TransformerException {
        Transformer transformer = this.createTransformer();
        transformer.transform(source, result);
    }
}

