/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.validation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.core.io.Resource;
import org.springframework.xml.sax.SaxUtils;
import org.springframework.xml.validation.XmlValidationException;
import org.springframework.xml.validation.XmlValidator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

abstract class Jaxp10ValidatorFactory {
    private static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    Jaxp10ValidatorFactory() {
    }

    static XmlValidator createValidator(Resource[] schemaResources, String schemaLanguage) throws IOException {
        InputSource[] inputSources = new InputSource[schemaResources.length];
        for (int i = 0; i < schemaResources.length; ++i) {
            inputSources[i] = SaxUtils.createInputSource(schemaResources[i]);
        }
        return new Jaxp10Validator(inputSources, schemaLanguage);
    }

    private static class ValidationErrorHandler
    extends DefaultHandler {
        private List<SAXParseException> errors = new ArrayList<SAXParseException>();

        private ValidationErrorHandler() {
        }

        private SAXParseException[] getErrors() {
            return this.errors.toArray(new SAXParseException[this.errors.size()]);
        }

        public void warning(SAXParseException ex) throws SAXException {
        }

        public void error(SAXParseException ex) throws SAXException {
            this.errors.add(ex);
        }

        public void fatalError(SAXParseException ex) throws SAXException {
            this.errors.add(ex);
        }
    }

    private static class Jaxp10Validator
    implements XmlValidator {
        private SAXParserFactory parserFactory;
        private TransformerFactory transformerFactory;
        private InputSource[] schemaInputSources;
        private String schemaLanguage;

        private Jaxp10Validator(InputSource[] schemaInputSources, String schemaLanguage) {
            this.schemaInputSources = schemaInputSources;
            this.schemaLanguage = schemaLanguage;
            this.transformerFactory = TransformerFactory.newInstance();
            this.parserFactory = SAXParserFactory.newInstance();
            this.parserFactory.setNamespaceAware(true);
            this.parserFactory.setValidating(true);
        }

        public SAXParseException[] validate(Source source) throws IOException {
            SAXParser parser = this.createSAXParser();
            ValidationErrorHandler errorHandler = new ValidationErrorHandler();
            try {
                if (source instanceof SAXSource) {
                    this.validateSAXSource((SAXSource)source, parser, errorHandler);
                } else if (source instanceof StreamSource) {
                    this.validateStreamSource((StreamSource)source, parser, errorHandler);
                } else if (source instanceof DOMSource) {
                    this.validateDOMSource((DOMSource)source, parser, errorHandler);
                } else {
                    throw new IllegalArgumentException("Source [" + source.getClass().getName() + "] is neither SAXSource, DOMSource, nor StreamSource");
                }
                return errorHandler.getErrors();
            }
            catch (SAXException ex) {
                throw new XmlValidationException("Could not validate source: " + ex.getMessage(), ex);
            }
        }

        private void validateDOMSource(DOMSource domSource, SAXParser parser, ValidationErrorHandler errorHandler) throws IOException, SAXException {
            try {
                Transformer transformer = this.transformerFactory.newTransformer();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                transformer.transform(domSource, new StreamResult(outputStream));
                ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                this.validateStreamSource(new StreamSource(inputStream), parser, errorHandler);
            }
            catch (TransformerException ex) {
                throw new XmlValidationException("Could not validate DOM source: " + ex.getMessage(), ex);
            }
        }

        private void validateStreamSource(StreamSource streamSource, SAXParser parser, ValidationErrorHandler errorHandler) throws SAXException, IOException {
            if (streamSource.getInputStream() != null) {
                parser.parse(streamSource.getInputStream(), (DefaultHandler)errorHandler);
            } else if (streamSource.getReader() != null) {
                parser.parse(new InputSource(streamSource.getReader()), (DefaultHandler)errorHandler);
            } else {
                throw new IllegalArgumentException("StreamSource contains neither InputStream nor Reader");
            }
        }

        private void validateSAXSource(SAXSource source, SAXParser parser, ValidationErrorHandler errorHandler) throws SAXException, IOException {
            parser.parse(source.getInputSource(), (DefaultHandler)errorHandler);
        }

        private SAXParser createSAXParser() {
            try {
                SAXParser parser = this.parserFactory.newSAXParser();
                parser.setProperty(Jaxp10ValidatorFactory.SCHEMA_LANGUAGE, this.schemaLanguage);
                parser.setProperty(Jaxp10ValidatorFactory.SCHEMA_SOURCE, this.schemaInputSources);
                return parser;
            }
            catch (ParserConfigurationException ex) {
                throw new XmlValidationException("Could not create SAXParser: " + ex.getMessage(), ex);
            }
            catch (SAXException ex) {
                throw new XmlValidationException("Could not create SAXParser: " + ex.getMessage(), ex);
            }
        }
    }
}

