/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.xpath;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.springframework.util.xml.StaxUtils;
import org.springframework.xml.namespace.SimpleNamespaceContext;
import org.springframework.xml.xpath.AbstractXPathTemplate;
import org.springframework.xml.xpath.NodeMapper;
import org.springframework.xml.xpath.XPathException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jaxp13XPathTemplate
extends AbstractXPathTemplate {
    private XPathFactory xpathFactory;

    public Jaxp13XPathTemplate() {
        this("http://java.sun.com/jaxp/xpath/dom");
    }

    public Jaxp13XPathTemplate(String xpathFactoryUri) {
        try {
            this.xpathFactory = XPathFactory.newInstance(xpathFactoryUri);
        }
        catch (XPathFactoryConfigurationException ex) {
            throw new XPathException("Could not create XPathFactory", ex);
        }
    }

    @Override
    public boolean evaluateAsBoolean(String expression, Source context) throws XPathException {
        Boolean result = (Boolean)this.evaluate(expression, context, XPathConstants.BOOLEAN);
        return result != null && result != false;
    }

    @Override
    public Node evaluateAsNode(String expression, Source context) throws XPathException {
        return (Node)this.evaluate(expression, context, XPathConstants.NODE);
    }

    @Override
    public List<Node> evaluateAsNodeList(String expression, Source context) throws XPathException {
        NodeList result = (NodeList)this.evaluate(expression, context, XPathConstants.NODESET);
        ArrayList<Node> nodes = new ArrayList<Node>(result.getLength());
        for (int i = 0; i < result.getLength(); ++i) {
            nodes.add(result.item(i));
        }
        return nodes;
    }

    @Override
    public double evaluateAsDouble(String expression, Source context) throws XPathException {
        Double result = (Double)this.evaluate(expression, context, XPathConstants.NUMBER);
        return result != null ? result : Double.NaN;
    }

    @Override
    public String evaluateAsString(String expression, Source context) throws XPathException {
        return (String)this.evaluate(expression, context, XPathConstants.STRING);
    }

    @Override
    public <T> T evaluateAsObject(String expression, Source context, NodeMapper<T> nodeMapper) throws XPathException {
        Node node = this.evaluateAsNode(expression, context);
        if (node != null) {
            try {
                return nodeMapper.mapNode(node, 0);
            }
            catch (DOMException ex) {
                throw new XPathException("Mapping resulted in DOMException", ex);
            }
        }
        return null;
    }

    @Override
    public <T> List<T> evaluate(String expression, Source context, NodeMapper<T> nodeMapper) throws XPathException {
        NodeList nodes = (NodeList)this.evaluate(expression, context, XPathConstants.NODESET);
        ArrayList<T> results = new ArrayList<T>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            try {
                results.add(nodeMapper.mapNode(nodes.item(i), i));
                continue;
            }
            catch (DOMException ex) {
                throw new XPathException("Mapping resulted in DOMException", ex);
            }
        }
        return results;
    }

    private Object evaluate(String expression, Source context, QName returnType) throws XPathException {
        XPath xpath = this.createXPath();
        if (this.getNamespaces() != null && !this.getNamespaces().isEmpty()) {
            SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();
            namespaceContext.setBindings(this.getNamespaces());
            xpath.setNamespaceContext(namespaceContext);
        }
        try {
            if (StaxUtils.isStaxSource((Source)context)) {
                Element element = this.getRootElement(context);
                return xpath.evaluate(expression, element, returnType);
            }
            if (context instanceof SAXSource) {
                SAXSource saxSource = (SAXSource)context;
                return xpath.evaluate(expression, saxSource.getInputSource(), returnType);
            }
            if (context instanceof DOMSource) {
                DOMSource domSource = (DOMSource)context;
                return xpath.evaluate(expression, domSource.getNode(), returnType);
            }
            if (context instanceof StreamSource) {
                InputSource inputSource;
                StreamSource streamSource = (StreamSource)context;
                if (streamSource.getInputStream() != null) {
                    inputSource = new InputSource(streamSource.getInputStream());
                } else if (streamSource.getReader() != null) {
                    inputSource = new InputSource(streamSource.getReader());
                } else {
                    throw new IllegalArgumentException("StreamSource contains neither InputStream nor Reader");
                }
                return xpath.evaluate(expression, inputSource, returnType);
            }
            throw new IllegalArgumentException("context type unknown");
        }
        catch (javax.xml.xpath.XPathException ex) {
            throw new XPathException("Could not evaluate XPath expression [" + expression + "]", ex);
        }
        catch (TransformerException ex) {
            throw new XPathException("Could not transform context to DOM Node", ex);
        }
    }

    private synchronized XPath createXPath() {
        return this.xpathFactory.newXPath();
    }
}

