/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.xpath;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.XPath;
import org.jaxen.dom.DOMXPath;
import org.springframework.xml.xpath.AbstractXPathTemplate;
import org.springframework.xml.xpath.NodeMapper;
import org.springframework.xml.xpath.XPathException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxenXPathTemplate
extends AbstractXPathTemplate {
    @Override
    public boolean evaluateAsBoolean(String expression, Source context) throws XPathException {
        try {
            XPath xpath = this.createXPath(expression);
            Element element = this.getRootElement(context);
            return xpath.booleanValueOf((Object)element);
        }
        catch (JaxenException ex) {
            throw new XPathException("Could not evaluate XPath expression [" + expression + "]", ex);
        }
        catch (TransformerException ex) {
            throw new XPathException("Could not transform context to DOM Node", ex);
        }
    }

    @Override
    public Node evaluateAsNode(String expression, Source context) throws XPathException {
        try {
            XPath xpath = this.createXPath(expression);
            Element element = this.getRootElement(context);
            return (Node)xpath.selectSingleNode((Object)element);
        }
        catch (JaxenException ex) {
            throw new XPathException("Could not evaluate XPath expression [" + expression + "]", ex);
        }
        catch (TransformerException ex) {
            throw new XPathException("Could not transform context to DOM Node", ex);
        }
    }

    @Override
    public List<Node> evaluateAsNodeList(String expression, Source context) throws XPathException {
        try {
            XPath xpath = this.createXPath(expression);
            Element element = this.getRootElement(context);
            return xpath.selectNodes((Object)element);
        }
        catch (JaxenException ex) {
            throw new XPathException("Could not evaluate XPath expression [" + expression + "]", ex);
        }
        catch (TransformerException ex) {
            throw new XPathException("Could not transform context to DOM Node", ex);
        }
    }

    @Override
    public double evaluateAsDouble(String expression, Source context) throws XPathException {
        try {
            XPath xpath = this.createXPath(expression);
            Element element = this.getRootElement(context);
            return xpath.numberValueOf((Object)element).doubleValue();
        }
        catch (JaxenException ex) {
            throw new XPathException("Could not evaluate XPath expression [" + expression + "]", ex);
        }
        catch (TransformerException ex) {
            throw new XPathException("Could not transform context to DOM Node", ex);
        }
    }

    @Override
    public String evaluateAsString(String expression, Source context) throws XPathException {
        try {
            XPath xpath = this.createXPath(expression);
            Element element = this.getRootElement(context);
            return xpath.stringValueOf((Object)element);
        }
        catch (JaxenException ex) {
            throw new XPathException("Could not evaluate XPath expression [" + expression + "]", ex);
        }
        catch (TransformerException ex) {
            throw new XPathException("Could not transform context to DOM Node", ex);
        }
    }

    @Override
    public <T> T evaluateAsObject(String expression, Source context, NodeMapper<T> nodeMapper) throws XPathException {
        try {
            XPath xpath = this.createXPath(expression);
            Element element = this.getRootElement(context);
            Node node = (Node)xpath.selectSingleNode((Object)element);
            if (node != null) {
                try {
                    return nodeMapper.mapNode(node, 0);
                }
                catch (DOMException ex) {
                    throw new XPathException("Mapping resulted in DOMException", ex);
                }
            }
            return null;
        }
        catch (JaxenException ex) {
            throw new XPathException("Could not evaluate XPath expression [" + expression + "]", ex);
        }
        catch (TransformerException ex) {
            throw new XPathException("Could not transform context to DOM Node", ex);
        }
    }

    @Override
    public <T> List<T> evaluate(String expression, Source context, NodeMapper<T> nodeMapper) throws XPathException {
        try {
            XPath xpath = this.createXPath(expression);
            Element element = this.getRootElement(context);
            List nodes = xpath.selectNodes((Object)element);
            ArrayList<T> results = new ArrayList<T>(nodes.size());
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = (Node)nodes.get(i);
                try {
                    results.add(nodeMapper.mapNode(node, i));
                    continue;
                }
                catch (DOMException ex) {
                    throw new XPathException("Mapping resulted in DOMException", ex);
                }
            }
            return results;
        }
        catch (JaxenException ex) {
            throw new XPathException("Could not evaluate XPath expression [" + expression + "]", ex);
        }
        catch (TransformerException ex) {
            throw new XPathException("Could not transform context to DOM Node", ex);
        }
    }

    private XPath createXPath(String expression) throws JaxenException {
        DOMXPath xpath = new DOMXPath(expression);
        if (this.getNamespaces() != null && !this.getNamespaces().isEmpty()) {
            xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(this.getNamespaces()));
        }
        return xpath;
    }
}

