/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.transform;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformerHelper {
    private volatile TransformerFactory transformerFactory;
    private Class<? extends TransformerFactory> transformerFactoryClass;

    public TransformerHelper() {
    }

    public TransformerHelper(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public TransformerHelper(Class<? extends TransformerFactory> transformerFactoryClass) {
        this.setTransformerFactoryClass(transformerFactoryClass);
    }

    public void setTransformerFactoryClass(Class<? extends TransformerFactory> transformerFactoryClass) {
        Assert.isAssignable(TransformerFactory.class, transformerFactoryClass);
        this.transformerFactoryClass = transformerFactoryClass;
    }

    protected TransformerFactory newTransformerFactory(Class<? extends TransformerFactory> transformerFactoryClass) {
        if (transformerFactoryClass != null) {
            try {
                return transformerFactoryClass.newInstance();
            }
            catch (Exception ex) {
                throw new TransformerFactoryConfigurationError(ex, "Could not instantiate TransformerFactory [" + transformerFactoryClass + "]");
            }
        }
        return TransformerFactory.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformerFactory getTransformerFactory() {
        TransformerFactory result = this.transformerFactory;
        if (result == null) {
            TransformerHelper transformerHelper = this;
            synchronized (transformerHelper) {
                result = this.transformerFactory;
                if (result == null) {
                    this.transformerFactory = result = this.newTransformerFactory(this.transformerFactoryClass);
                }
            }
        }
        return result;
    }

    public Transformer createTransformer() throws TransformerConfigurationException {
        return this.getTransformerFactory().newTransformer();
    }

    public void transform(Source source, Result result) throws TransformerException {
        Transformer transformer = this.createTransformer();
        transformer.transform(source, result);
    }
}

