/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.validation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.springframework.core.io.Resource;
import org.springframework.xml.validation.SchemaLoaderUtils;
import org.springframework.xml.validation.ValidationErrorHandler;
import org.springframework.xml.validation.XmlValidationException;
import org.springframework.xml.validation.XmlValidator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

abstract class Jaxp13ValidatorFactory {
    Jaxp13ValidatorFactory() {
    }

    static XmlValidator createValidator(Resource[] resources, String schemaLanguage) throws IOException {
        try {
            Schema schema = SchemaLoaderUtils.loadSchema(resources, schemaLanguage);
            return new Jaxp13Validator(schema);
        }
        catch (SAXException ex) {
            throw new XmlValidationException("Could not create Schema: " + ex.getMessage(), ex);
        }
    }

    private static class Jaxp13Validator
    implements XmlValidator {
        private Schema schema;

        public Jaxp13Validator(Schema schema) {
            this.schema = schema;
        }

        @Override
        public SAXParseException[] validate(Source source) throws IOException {
            return this.validate(source, null);
        }

        @Override
        public SAXParseException[] validate(Source source, ValidationErrorHandler errorHandler) throws IOException {
            if (errorHandler == null) {
                errorHandler = new DefaultValidationErrorHandler();
            }
            Validator validator = this.schema.newValidator();
            validator.setErrorHandler(errorHandler);
            try {
                validator.validate(source);
                return errorHandler.getErrors();
            }
            catch (SAXException ex) {
                throw new XmlValidationException("Could not validate source: " + ex.getMessage(), ex);
            }
        }
    }

    private static class DefaultValidationErrorHandler
    implements ValidationErrorHandler {
        private List<SAXParseException> errors = new ArrayList<SAXParseException>();

        private DefaultValidationErrorHandler() {
        }

        @Override
        public SAXParseException[] getErrors() {
            return this.errors.toArray(new SAXParseException[this.errors.size()]);
        }

        @Override
        public void warning(SAXParseException ex) throws SAXException {
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            this.errors.add(ex);
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            this.errors.add(ex);
        }
    }
}

