/*
 * Decompiled with CFR 0.152.
 */
package org.sputnikdev.bluetooth.gattparser;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.BitSet;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.AbstractConverter;
import org.apache.commons.beanutils.converters.ArrayConverter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.BigIntegerConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.StringConverter;
import org.sputnikdev.bluetooth.gattparser.num.TwosComplementNumberFormatter;
import org.sputnikdev.bluetooth.gattparser.spec.Enumeration;
import org.sputnikdev.bluetooth.gattparser.spec.Field;
import org.sputnikdev.bluetooth.gattparser.spec.FieldFormat;
import org.sputnikdev.bluetooth.gattparser.spec.FieldType;
import org.sputnikdev.bluetooth.gattparser.spec.FlagUtils;

public class FieldHolder {
    private final Field field;
    private Object value;

    protected FieldHolder(Field field, Object value) {
        this.field = field;
        this.value = value;
    }

    protected FieldHolder(Field field) {
        this.field = field;
    }

    public Field getField() {
        return this.field;
    }

    public boolean isNumber() {
        return this.field.getFormat().isNumber();
    }

    public boolean isBoolean() {
        return this.field.getFormat().isBoolean();
    }

    public boolean isString() {
        return this.field.getFormat().isString();
    }

    public boolean isStruct() {
        return this.field.getFormat().isStruct();
    }

    public Integer getInteger(Integer def) {
        Integer result = (Integer)new IntegerConverter(null).convert(Integer.class, this.prepareValue());
        if (result != null) {
            double multiplier = this.getMultiplier();
            double offset = this.getOffset();
            if (multiplier != 1.0 || offset != 0.0) {
                return (int)Math.round((double)result.intValue() * multiplier + offset);
            }
            return result;
        }
        return def;
    }

    public Long getLong(Long def) {
        Long result = (Long)new LongConverter(null).convert(Long.class, this.prepareValue());
        if (result != null) {
            double multiplier = this.getMultiplier();
            double offset = this.getOffset();
            if (multiplier != 1.0 || offset != 0.0) {
                return Math.round((double)result.longValue() * multiplier + offset);
            }
            return result;
        }
        return def;
    }

    public BigInteger getBigInteger(BigInteger def) {
        BigDecimal result = (BigDecimal)new BigDecimalConverter(null).convert(BigDecimal.class, this.prepareValue());
        return result != null ? result.multiply(BigDecimal.valueOf(this.getMultiplier())).add(BigDecimal.valueOf(this.getOffset())).setScale(0, RoundingMode.HALF_UP).toBigInteger() : def;
    }

    public BigDecimal getBigDecimal(BigDecimal def) {
        BigDecimal result = (BigDecimal)new BigDecimalConverter(null).convert(BigDecimal.class, this.prepareValue());
        return result != null ? result.multiply(BigDecimal.valueOf(this.getMultiplier())) : def;
    }

    public Float getFloat(Float def) {
        Float result = (Float)new FloatConverter(null).convert(Float.class, this.prepareValue());
        if (result != null) {
            return Float.valueOf((float)((double)result.floatValue() * this.getMultiplier() + this.getOffset()));
        }
        return def;
    }

    public Double getDouble(Double def) {
        Double result = (Double)new FloatConverter(null).convert(Double.class, this.prepareValue());
        if (result != null) {
            return result * this.getMultiplier() + this.getOffset();
        }
        return def;
    }

    public Boolean getBoolean(Boolean def) {
        return (Boolean)new BooleanConverter((Object)def).convert(Boolean.class, this.prepareValue());
    }

    public String getString(String def) {
        return (String)new StringConverter((Object)def).convert(String.class, this.prepareValue());
    }

    public byte[] getBytes(byte[] def) {
        return (byte[])new ArrayConverter(byte[].class, (Converter)new ByteConverter()).convert(byte[].class, this.value);
    }

    public Integer getInteger() {
        return this.getInteger(null);
    }

    public Long getLong() {
        return this.getLong(null);
    }

    public BigInteger getBigInteger() {
        return this.getBigInteger(null);
    }

    public BigDecimal getBigDecimal() {
        return this.getBigDecimal(null);
    }

    public Float getFloat() {
        return this.getFloat(null);
    }

    public Double getDouble() {
        return this.getDouble(null);
    }

    public Boolean getBoolean() {
        return this.getBoolean(null);
    }

    public String getString() {
        return this.getString(null);
    }

    public byte[] getBytes() {
        return this.getBytes(null);
    }

    public Object getRawValue() {
        return this.value;
    }

    public Enumeration getEnumeration() {
        BigInteger key;
        if (this.field.getFormat().isStruct() && this.value instanceof byte[]) {
            byte[] data = (byte[])this.value;
            key = new TwosComplementNumberFormatter().deserializeBigInteger(BitSet.valueOf(data), data.length * 8, false);
        } else if (this.field.getFormat().isString() && this.value instanceof String) {
            String encoding = this.field.getFormat().getType() == FieldType.UTF8S ? "UTF-8" : "UTF-16";
            try {
                byte[] data = ((String)this.value).getBytes(encoding);
                key = new TwosComplementNumberFormatter().deserializeBigInteger(BitSet.valueOf(data), data.length * 8, false);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        } else {
            key = this.getBigInteger();
        }
        return FlagUtils.getEnumeration(this.field, key).orElse(null);
    }

    public String getEnumerationValue() {
        Enumeration enumeration = this.getEnumeration();
        return enumeration != null ? enumeration.getValue() : null;
    }

    public String getEnumerationRequires() {
        Enumeration enumeration = this.getEnumeration();
        return enumeration != null ? enumeration.getRequires() : null;
    }

    public void setBoolean(Boolean value) {
        this.value = value;
    }

    public void setInteger(Integer value) {
        if (value == null) {
            this.value = null;
        } else {
            Double maximum = this.field.getMaximum();
            if (maximum != null && maximum < (double)value.intValue()) {
                throw new IllegalArgumentException("Value [" + value + "] is greater than maximum: " + maximum);
            }
            Double minimum = this.field.getMinimum();
            if (minimum != null && minimum > (double)value.intValue()) {
                throw new IllegalArgumentException("Value [" + value + "] is less than minimum: " + minimum);
            }
            double multiplier = this.getMultiplier();
            double offset = this.getOffset();
            this.value = multiplier != 1.0 || offset != 0.0 ? this.getConverter().convert(null, (Object)Math.round(((double)value.intValue() - offset) / multiplier)) : this.getConverter().convert(null, (Object)value);
        }
    }

    public void setLong(Long value) {
        if (value == null) {
            this.value = null;
        } else {
            Double maximum = this.field.getMaximum();
            if (maximum != null && maximum < (double)value.longValue()) {
                throw new IllegalArgumentException("Value [" + value + "] is greater than maximum: " + maximum);
            }
            Double minimum = this.field.getMinimum();
            if (minimum != null && minimum > (double)value.longValue()) {
                throw new IllegalArgumentException("Value [" + value + "] is less than minimum: " + minimum);
            }
            double multiplier = this.getMultiplier();
            double offset = this.getOffset();
            this.value = multiplier != 1.0 || offset != 0.0 ? this.getConverter().convert(null, (Object)Math.round(((double)value.longValue() - offset) / multiplier)) : this.getConverter().convert(null, (Object)value);
        }
    }

    public void setBigInteger(BigInteger value) {
        if (value == null) {
            this.value = null;
        } else {
            BigDecimal vl = new BigDecimal(value);
            Double maximum = this.field.getMaximum();
            if (maximum != null && vl.compareTo(new BigDecimal(maximum)) > 0) {
                throw new IllegalArgumentException("Value [" + value + "] is greater than maximum: " + maximum);
            }
            Double minimum = this.field.getMinimum();
            if (minimum != null && vl.compareTo(new BigDecimal(minimum)) < 0) {
                throw new IllegalArgumentException("Value [" + value + "] is less than minimum: " + minimum);
            }
            double multiplier = this.getMultiplier();
            double offset = this.getOffset();
            BigInteger adjusted = multiplier != 1.0 || offset != 0.0 ? vl.subtract(BigDecimal.valueOf(offset)).setScale(0, RoundingMode.HALF_UP).divide(BigDecimal.valueOf(multiplier)).toBigInteger() : value;
            this.value = this.field.getFormat().isStruct() ? (Object)new TwosComplementNumberFormatter().serialize(adjusted, adjusted.bitLength(), false).toByteArray() : this.getConverter().convert(null, (Object)adjusted);
        }
    }

    public void setFloat(Float value) {
        if (value == null) {
            this.value = null;
        } else {
            Double maximum = this.field.getMaximum();
            if (maximum != null && maximum < (double)value.floatValue()) {
                throw new IllegalArgumentException("Value [" + value + "] is greater than maximum: " + maximum);
            }
            Double minimum = this.field.getMinimum();
            if (minimum != null && minimum > (double)value.floatValue()) {
                throw new IllegalArgumentException("Value [" + value + "] is less than minimum: " + minimum);
            }
            this.value = this.getConverter().convert(null, (Object)(((double)value.floatValue() - this.getOffset()) / this.getMultiplier()));
        }
    }

    public void setDouble(Double value) {
        if (value == null) {
            this.value = null;
        } else {
            Double maximum = this.field.getMaximum();
            if (maximum != null && maximum < value) {
                throw new IllegalArgumentException("Value [" + value + "] is greater than maximum: " + maximum);
            }
            Double minimum = this.field.getMinimum();
            if (minimum != null && minimum > value) {
                throw new IllegalArgumentException("Value [" + value + "] is less than minimum: " + minimum);
            }
            this.value = this.getConverter().convert(null, (Object)((value - this.getOffset()) / this.getMultiplier()));
        }
    }

    public void setString(String value) {
        this.value = value;
    }

    public void setStruct(byte[] struct) {
        this.value = struct;
    }

    public void setEnumeration(Enumeration value) {
        if (value == null) {
            this.value = null;
        } else {
            BigInteger key = value.getKey();
            if (this.field.getFormat().isStruct()) {
                this.value = new TwosComplementNumberFormatter().serialize(key, key.bitLength(), false).toByteArray();
            } else if (this.field.getFormat().isString()) {
                String encoding = this.field.getFormat().getType() == FieldType.UTF8S ? "UTF-8" : "UTF-16";
                try {
                    this.value = new String(new TwosComplementNumberFormatter().serialize(key, key.bitLength(), false).toByteArray(), encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            } else {
                this.setBigInteger(key);
            }
        }
    }

    public void setRawValue(Object value) {
        this.value = value;
    }

    public boolean isValueSet() {
        return this.value != null;
    }

    public String toString() {
        return this.getString();
    }

    private double getMultiplier() {
        double multiplier = 1.0;
        if (this.field.getDecimalExponent() != null) {
            multiplier = Math.pow(10.0, this.field.getDecimalExponent().intValue());
        }
        if (this.field.getBinaryExponent() != null) {
            multiplier *= Math.pow(2.0, this.field.getBinaryExponent().intValue());
        }
        if (this.field.getMultiplier() != null && this.field.getMultiplier() != 0) {
            multiplier *= (double)this.field.getMultiplier().intValue();
        }
        return multiplier;
    }

    private double getOffset() {
        return this.field.getOffset() != null ? this.field.getOffset() : 0.0;
    }

    private AbstractConverter getConverter() {
        FieldFormat fieldFormat = this.field.getFormat();
        int size = fieldFormat.getSize();
        switch (fieldFormat.getType()) {
            case BOOLEAN: {
                return new BooleanConverter();
            }
            case UINT: {
                if (size < 32) {
                    return new IntegerConverter();
                }
                if (size < 64) {
                    return new LongConverter();
                }
                return new BigIntegerConverter();
            }
            case SINT: {
                if (size <= 32) {
                    return new IntegerConverter();
                }
                if (size <= 64) {
                    return new LongConverter();
                }
                return new BigIntegerConverter();
            }
            case FLOAT_IEE754: 
            case FLOAT_IEE11073: {
                return size <= 32 ? new FloatConverter() : new DoubleConverter();
            }
            case UTF8S: 
            case UTF16S: {
                return new StringConverter();
            }
        }
        throw new IllegalStateException("Unsupported field format: " + (Object)((Object)fieldFormat.getType()));
    }

    private Object prepareValue() {
        if (this.field.getFormat().isStruct() && this.value instanceof byte[]) {
            byte[] data = (byte[])this.value;
            return new TwosComplementNumberFormatter().deserializeBigInteger(BitSet.valueOf(data), data.length * 8, false);
        }
        return this.value;
    }
}

