/*
 * Decompiled with CFR 0.152.
 */
package org.sputnikdev.bluetooth.gattparser.spec;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sputnikdev.bluetooth.gattparser.spec.Bit;
import org.sputnikdev.bluetooth.gattparser.spec.BitField;
import org.sputnikdev.bluetooth.gattparser.spec.Characteristic;
import org.sputnikdev.bluetooth.gattparser.spec.CharacteristicAccess;
import org.sputnikdev.bluetooth.gattparser.spec.Characteristics;
import org.sputnikdev.bluetooth.gattparser.spec.Enumeration;
import org.sputnikdev.bluetooth.gattparser.spec.Enumerations;
import org.sputnikdev.bluetooth.gattparser.spec.Examples;
import org.sputnikdev.bluetooth.gattparser.spec.Field;
import org.sputnikdev.bluetooth.gattparser.spec.FlagUtils;
import org.sputnikdev.bluetooth.gattparser.spec.InformativeText;
import org.sputnikdev.bluetooth.gattparser.spec.Properties;
import org.sputnikdev.bluetooth.gattparser.spec.Reserved;
import org.sputnikdev.bluetooth.gattparser.spec.Service;
import org.sputnikdev.bluetooth.gattparser.spec.Value;

public class BluetoothGattSpecificationReader {
    private static final String MANDATORY_FLAG = "Mandatory";
    private static final String OPTIONAL_FLAG = "Optional";
    private static final String SPEC_ROOT_FOLDER_NAME = "gatt";
    private static final String SPEC_SERVICES_FOLDER_NAME = "service";
    private static final String SPEC_CHARACTERISTICS_FOLDER_NAME = "characteristic";
    private static final String SPEC_REGISTRY_FILE_NAME = "gatt_spec_registry.json";
    private static final String CLASSPATH_SPEC_FULL_SERVICES_FOLDER_NAME = "gatt/service";
    private static final String CLASSPATH_SPEC_FULL_CHARACTERISTICS_FOLDER_NAME = "gatt/characteristic";
    private static final String CLASSPATH_SPEC_FULL_CHARACTERISTIC_FILE_NAME = "gatt/characteristic/gatt_spec_registry.json";
    private static final String CLASSPATH_SPEC_FULL_SERVICE_FILE_NAME = "gatt/service/gatt_spec_registry.json";
    private final Logger logger = LoggerFactory.getLogger(BluetoothGattSpecificationReader.class);
    private final Map<String, URL> servicesRegistry = new HashMap<String, URL>();
    private final Map<String, URL> characteristicsRegistry = new HashMap<String, URL>();
    private final Map<String, String> characteristicsTypeRegistry = new HashMap<String, String>();
    private final Map<String, Service> services = new HashMap<String, Service>();
    private final Map<String, Characteristic> characteristicsByUUID = new HashMap<String, Characteristic>();
    private final Map<String, Characteristic> characteristicsByType = new HashMap<String, Characteristic>();

    public BluetoothGattSpecificationReader() {
        URL servicesResource = this.getClass().getClassLoader().getResource(CLASSPATH_SPEC_FULL_SERVICE_FILE_NAME);
        URL characteristicsResource = this.getClass().getClassLoader().getResource(CLASSPATH_SPEC_FULL_CHARACTERISTIC_FILE_NAME);
        this.loadExtensionsFromCatalogResources(servicesResource, characteristicsResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service getService(String uuid) {
        if (this.services.containsKey(uuid)) {
            return this.services.get(uuid);
        }
        if (this.servicesRegistry.containsKey(uuid)) {
            Map<String, Service> map = this.services;
            synchronized (map) {
                if (!this.services.containsKey(uuid)) {
                    Service service = this.loadService(uuid);
                    this.addService(service);
                    return service;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Characteristic getCharacteristicByUUID(String uuid) {
        if (this.characteristicsByUUID.containsKey(uuid)) {
            return this.characteristicsByUUID.get(uuid);
        }
        if (this.characteristicsRegistry.containsKey(uuid)) {
            Map<String, Characteristic> map = this.characteristicsByUUID;
            synchronized (map) {
                if (!this.characteristicsByUUID.containsKey(uuid)) {
                    Characteristic characteristic = this.loadCharacteristic(uuid);
                    this.addCharacteristic(characteristic);
                    return characteristic;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Characteristic getCharacteristicByType(String type) {
        if (this.characteristicsByType.containsKey(type)) {
            return this.characteristicsByType.get(type);
        }
        if (this.characteristicsTypeRegistry.containsKey(type)) {
            Map<String, Characteristic> map = this.characteristicsByUUID;
            synchronized (map) {
                if (!this.characteristicsByType.containsKey(type)) {
                    Characteristic characteristic = this.loadCharacteristic(this.characteristicsTypeRegistry.get(type));
                    this.addCharacteristic(characteristic);
                    return characteristic;
                }
            }
        }
        return null;
    }

    public Collection<Characteristic> getCharacteristics() {
        return new ArrayList<Characteristic>(this.characteristicsByUUID.values());
    }

    public Collection<Service> getServices() {
        return new ArrayList<Service>(this.services.values());
    }

    public List<Field> getFields(Characteristic characteristic) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (characteristic.getValue() == null) {
            return Collections.emptyList();
        }
        for (Field field : characteristic.getValue().getFields()) {
            if (field.getReference() == null) {
                fields.add(field);
                continue;
            }
            fields.addAll(this.getFields(this.getCharacteristicByType(field.getReference().trim())));
        }
        return Collections.unmodifiableList(fields);
    }

    public void loadExtensionsFromFolder(String path) {
        this.logger.info("Reading services and characteristics from folder: " + path);
        String servicesFolderName = path + File.separator + SPEC_SERVICES_FOLDER_NAME;
        String characteristicsFolderName = path + File.separator + SPEC_CHARACTERISTICS_FOLDER_NAME;
        this.logger.info("Reading services from folder: " + servicesFolderName);
        this.readServices(this.getFilesFromFolder(servicesFolderName));
        this.logger.info("Reading characteristics from folder: " + characteristicsFolderName);
        this.readCharacteristics(this.getFilesFromFolder(characteristicsFolderName));
    }

    private static URL getSpecResourceURL(URL catalogURL, String characteristicType) throws MalformedURLException {
        String catalogFilePath = catalogURL.getFile();
        int lastSlashPos = catalogFilePath.lastIndexOf(47);
        String specFilePath = catalogFilePath;
        if (lastSlashPos >= 0) {
            specFilePath = catalogFilePath.substring(0, lastSlashPos);
        }
        specFilePath = specFilePath + "/" + characteristicType + ".xml";
        return new URL(catalogURL.getProtocol(), catalogURL.getHost(), catalogURL.getPort(), specFilePath);
    }

    private Map<String, URL> catalogToURLs(URL serviceRegistry, Map<String, String> xmlEntry) {
        HashMap<String, URL> processed = new HashMap<String, URL>();
        for (Map.Entry<String, String> entry : xmlEntry.entrySet()) {
            try {
                URL specUrl = BluetoothGattSpecificationReader.getSpecResourceURL(serviceRegistry, entry.getValue());
                this.logger.debug("Loaded {} underneath {}", (Object)entry.getValue(), (Object)specUrl);
                processed.put(entry.getKey(), specUrl);
            }
            catch (MalformedURLException err) {
                this.logger.error("Failed to make GATT registry entry for {} underneath {}", (Object)entry.getValue(), (Object)serviceRegistry);
            }
        }
        return processed;
    }

    public void loadExtensionsFromCatalogResources(URL servicesResource, URL characteristicsResource) {
        Map<String, String> loadedServices = this.readRegistryFromCatalogResource(servicesResource);
        this.logger.info("Loaded {} GATT specifications from resource {}", (Object)loadedServices.size(), (Object)servicesResource);
        Map<String, URL> loadedServicesRegistry = this.catalogToURLs(servicesResource, loadedServices);
        Map<String, String> loadedCharacteristics = this.readRegistryFromCatalogResource(characteristicsResource);
        this.logger.info("Loaded {} GATT specifications from resource {}", (Object)loadedCharacteristics.size(), (Object)characteristicsResource);
        Map<String, URL> loadedCharacteristicsRegistry = this.catalogToURLs(characteristicsResource, loadedCharacteristics);
        Map<String, String> loadedTypeRegistry = loadedCharacteristics.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        this.servicesRegistry.putAll(loadedServicesRegistry);
        this.characteristicsRegistry.putAll(loadedCharacteristicsRegistry);
        this.characteristicsTypeRegistry.putAll(loadedTypeRegistry);
    }

    Set<String> getRequirements(List<Field> fields, Field flags) {
        HashSet<String> result = new HashSet<String>();
        Iterator<Field> iterator = fields.iterator();
        while (iterator.hasNext()) {
            List<String> requirements;
            Field field = iterator.next();
            if (field.getBitField() != null || (requirements = field.getRequirements()) == null || requirements.isEmpty() || requirements.contains(MANDATORY_FLAG) || requirements.size() == 1 && requirements.contains(OPTIONAL_FLAG) && !iterator.hasNext()) continue;
            result.addAll(requirements);
        }
        return result;
    }

    private void addCharacteristic(Characteristic characteristic) {
        this.validate(characteristic);
        this.characteristicsByUUID.put(characteristic.getUuid(), characteristic);
        this.characteristicsByType.put(characteristic.getType().trim(), characteristic);
    }

    private void addService(Service service) {
        this.services.put(service.getUuid(), service);
    }

    private void validate(Characteristic characteristic) {
        List<Field> fields = characteristic.getValue().getFields();
        if (fields.isEmpty()) {
            this.logger.warn("Characteristic \"{}\" does not have any Fields tags, therefore reading this characteristic will not be possible.", (Object)characteristic.getName());
            return;
        }
        Field flags = null;
        Field opCodes = null;
        for (Field field : fields) {
            if (FlagUtils.isFlagsField(field)) {
                flags = field;
            }
            if (!FlagUtils.isOpCodesField(field)) continue;
            opCodes = field;
        }
        Set<Object> readFlags = flags != null ? FlagUtils.getAllFlags(flags) : Collections.emptySet();
        Set<Object> writeFlags = opCodes != null ? FlagUtils.getAllOpCodes(opCodes) : Collections.emptySet();
        Set<String> requirements = this.getRequirements(fields, flags);
        HashSet<String> unfulfilledReadRequirements = new HashSet<String>(requirements);
        unfulfilledReadRequirements.removeAll(readFlags);
        HashSet<String> unfulfilledWriteRequirements = new HashSet<String>(requirements);
        unfulfilledWriteRequirements.removeAll(writeFlags);
        if (unfulfilledReadRequirements.isEmpty()) {
            characteristic.setValidForRead(true);
        }
        if (unfulfilledWriteRequirements.isEmpty()) {
            characteristic.setValidForWrite(true);
        }
        if (!unfulfilledReadRequirements.isEmpty() && !unfulfilledWriteRequirements.isEmpty()) {
            this.logger.warn("Characteristic \"{}\" is not valid neither for read nor for write operation due to unfulfilled requirements: read ({}) write ({}).", new Object[]{characteristic.getName(), unfulfilledReadRequirements, unfulfilledWriteRequirements});
        }
    }

    private List<URL> getFilesFromFolder(String folder) {
        File folderFile = new File(folder);
        File[] files = folderFile.listFiles();
        if (!folderFile.exists() || !folderFile.isDirectory() || files == null || files.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (File file : files) {
                urls.add(file.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        return urls;
    }

    private Service loadService(String uuid) {
        URL url = this.servicesRegistry.get(uuid);
        return this.getService(url);
    }

    private Characteristic loadCharacteristic(String uuid) {
        URL url = this.characteristicsRegistry.get(uuid);
        return this.getCharacteristic(url);
    }

    private void readServices(List<URL> files) {
        for (URL file : files) {
            Service service = this.getService(file);
            if (service == null) continue;
            this.addService(service);
        }
    }

    private void readCharacteristics(List<URL> files) {
        for (URL file : files) {
            Characteristic characteristic = this.getCharacteristic(file);
            if (characteristic == null) continue;
            this.addCharacteristic(characteristic);
        }
    }

    private Service getService(URL file) {
        return (Service)this.getSpec(file);
    }

    private Characteristic getCharacteristic(URL file) {
        return (Characteristic)this.getSpec(file);
    }

    private <T> T getSpec(URL file) {
        try {
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
            xstream.autodetectAnnotations(true);
            xstream.processAnnotations(Bit.class);
            xstream.processAnnotations(BitField.class);
            xstream.processAnnotations(Characteristic.class);
            xstream.processAnnotations(Enumeration.class);
            xstream.processAnnotations(Enumerations.class);
            xstream.processAnnotations(Field.class);
            xstream.processAnnotations(InformativeText.class);
            xstream.processAnnotations(Service.class);
            xstream.processAnnotations(Value.class);
            xstream.processAnnotations(Reserved.class);
            xstream.processAnnotations(Examples.class);
            xstream.processAnnotations(CharacteristicAccess.class);
            xstream.processAnnotations(Characteristics.class);
            xstream.processAnnotations(Properties.class);
            xstream.ignoreUnknownElements();
            xstream.setClassLoader(Characteristic.class.getClassLoader());
            return (T)xstream.fromXML(file);
        }
        catch (Exception e) {
            this.logger.error("Could not read file: " + file, (Throwable)e);
            return null;
        }
    }

    private Map<String, String> readRegistryFromCatalogResource(URL serviceRegistry) {
        this.logger.info("Reading GATT registry from: {}", (Object)serviceRegistry);
        if (serviceRegistry == null) {
            throw new IllegalStateException("GATT spec registry file is missing");
        }
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        Gson gson = new Gson();
        JsonReader jsonReader = null;
        try {
            jsonReader = new JsonReader((Reader)new InputStreamReader(serviceRegistry.openStream(), "UTF-8"));
            Map map = (Map)gson.fromJson(jsonReader, type);
            return map;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (jsonReader != null) {
                try {
                    jsonReader.close();
                }
                catch (IOException e) {
                    this.logger.error("Could not close stream", (Throwable)e);
                }
            }
        }
    }
}

