/*
 * Decompiled with CFR 0.152.
 */
package org.sputnikdev.bluetooth.gattparser.spec;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.math.BigInteger;
import java.util.List;
import org.sputnikdev.bluetooth.gattparser.spec.BitField;
import org.sputnikdev.bluetooth.gattparser.spec.Enumeration;
import org.sputnikdev.bluetooth.gattparser.spec.Enumerations;
import org.sputnikdev.bluetooth.gattparser.spec.FieldFormat;
import org.sputnikdev.bluetooth.gattparser.spec.FlagUtils;

@XStreamAlias(value="Field")
public class Field {
    @XStreamAsAttribute
    private String name;
    @XStreamAlias(value="InformativeText")
    private String informativeText;
    @XStreamImplicit(itemFieldName="Requirement")
    private List<String> requirements;
    @XStreamAlias(value="Reference")
    private String reference;
    @XStreamAlias(value="Format")
    private String format;
    @XStreamAlias(value="BitField")
    private BitField bitField;
    @XStreamAlias(value="DecimalExponent")
    private Integer decimalExponent;
    @XStreamAlias(value="BinaryExponent")
    private Integer binaryExponent;
    @XStreamAlias(value="Multiplier")
    private Integer multiplier;
    @XStreamAlias(value="Unit")
    private String unit;
    @XStreamAlias(value="Minimum")
    private Double minimum;
    @XStreamAlias(value="Maximum")
    private Double maximum;
    @XStreamAlias(value="Offset")
    private Double offset;
    @XStreamAlias(value="Enumerations")
    private Enumerations enumerations;
    @XStreamAsAttribute
    private boolean unknown;
    @XStreamAsAttribute
    private boolean system;

    public String getName() {
        return this.name != null ? this.name.trim() : null;
    }

    public String getInformativeText() {
        return this.informativeText;
    }

    public List<String> getRequirements() {
        return this.requirements;
    }

    public FieldFormat getFormat() {
        return FieldFormat.valueOf(this.format);
    }

    public BitField getBitField() {
        return this.bitField;
    }

    public Integer getDecimalExponent() {
        return this.decimalExponent;
    }

    public Integer getBinaryExponent() {
        return this.binaryExponent;
    }

    public Integer getMultiplier() {
        return this.multiplier;
    }

    public String getUnit() {
        return this.unit;
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public Double getOffset() {
        return this.offset;
    }

    public Enumerations getEnumerations() {
        return this.enumerations;
    }

    public String getReference() {
        return this.reference;
    }

    public boolean isUnknown() {
        return this.unknown;
    }

    public boolean isSystem() {
        return this.system;
    }

    public boolean isFlagField() {
        return FlagUtils.isFlagsField(this);
    }

    public boolean isOpCodesField() {
        return FlagUtils.isOpCodesField(this);
    }

    public boolean hasEnumerations() {
        return this.enumerations != null && this.enumerations.getEnumerations() != null && !this.enumerations.getEnumerations().isEmpty();
    }

    public Enumeration getEnumeration(BigInteger key) {
        return FlagUtils.getEnumeration(this, key).orElse(null);
    }

    public List<Enumeration> getEnumerations(String value) {
        return FlagUtils.getEnumerations(this, value);
    }
}

