/*
 * Decompiled with CFR 0.152.
 */
package org.sputnikdev.bluetooth.gattparser.spec;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sputnikdev.bluetooth.gattparser.BluetoothGattParserFactory;
import org.sputnikdev.bluetooth.gattparser.spec.Bit;
import org.sputnikdev.bluetooth.gattparser.spec.Enumeration;
import org.sputnikdev.bluetooth.gattparser.spec.Enumerations;
import org.sputnikdev.bluetooth.gattparser.spec.Field;

public final class FlagUtils {
    private FlagUtils() {
    }

    public static Set<String> getReadFlags(List<Field> fields, byte[] data) {
        HashSet<String> flags = new HashSet<String>();
        int index = 0;
        for (Field field : fields) {
            if (FlagUtils.isFlagsField(field)) {
                int[] values = FlagUtils.parseReadFlags(field, data, index);
                int bitIndex = 0;
                for (Bit bit : field.getBitField().getBits()) {
                    List<String> flgs;
                    String requires = bit.getFlag((byte)values[bitIndex++]);
                    if (requires == null || (flgs = Arrays.asList(requires.split(","))).isEmpty()) continue;
                    flags.addAll(flgs);
                }
                break;
            }
            if (field.getReference() != null) break;
            if (field.getFormat() == null) {
                throw new IllegalStateException("A filed is missing its format: " + field.getName());
            }
            index += field.getFormat().getSize();
        }
        return flags;
    }

    public static String getRequires(Field field, BigInteger key) {
        return FlagUtils.getEnumeration(field, key).map(Enumeration::getRequires).orElse(null);
    }

    public static Optional<Enumeration> getEnumeration(Field field, BigInteger key) {
        if (key == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(field.getEnumerations()).map(Enumerations::getEnumerations).map(Collection::stream).orElse(Stream.empty()).filter(e -> key.equals(e.getKey())).findAny();
    }

    public static List<Enumeration> getEnumerations(Field field, String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        return Optional.ofNullable(field.getEnumerations()).map(Enumerations::getEnumerations).map(Collection::stream).orElse(Stream.empty()).filter(e -> value.equals(e.getValue())).collect(Collectors.toList());
    }

    public static boolean isFlagsField(Field field) {
        return "flags".equalsIgnoreCase(field.getName()) && field.getBitField() != null;
    }

    public static boolean isOpCodesField(Field field) {
        String name = field.getName();
        return ("op code".equalsIgnoreCase(name) || "op codes".equalsIgnoreCase(name)) && field.getEnumerations() != null && !field.getEnumerations().getEnumerations().isEmpty();
    }

    static Set<String> getAllFlags(Field flagsField) {
        HashSet<String> result = new HashSet<String>();
        if (flagsField != null && flagsField.getBitField() != null) {
            for (Bit bit : flagsField.getBitField().getBits()) {
                for (Enumeration enumeration : bit.getEnumerations().getEnumerations()) {
                    if (enumeration.getRequires() == null) continue;
                    result.add(enumeration.getRequires());
                }
            }
        }
        return result;
    }

    static Set<String> getAllOpCodes(Field field) {
        HashSet<String> result = new HashSet<String>();
        if (field.getEnumerations() == null || field.getEnumerations().getEnumerations() == null) {
            return Collections.EMPTY_SET;
        }
        for (Enumeration enumeration : field.getEnumerations().getEnumerations()) {
            result.add(enumeration.getRequires());
        }
        return result;
    }

    static Field getFlags(List<Field> fields) {
        for (Field field : fields) {
            if (!FlagUtils.isFlagsField(field)) continue;
            return field;
        }
        return null;
    }

    static Field getOpCodes(List<Field> fields) {
        for (Field field : fields) {
            if (!FlagUtils.isOpCodesField(field)) continue;
            return field;
        }
        return null;
    }

    static int[] parseReadFlags(Field flagsField, byte[] raw, int index) {
        BitSet bitSet = BitSet.valueOf(raw).get(index, index + flagsField.getFormat().getSize());
        List<Bit> bits = flagsField.getBitField().getBits();
        int[] flags = new int[bits.size()];
        int offset = 0;
        for (int i = 0; i < bits.size(); ++i) {
            int size = bits.get(i).getSize();
            flags[i] = BluetoothGattParserFactory.getTwosComplementNumberFormatter().deserializeInteger(bitSet.get(offset, offset + size), size, false);
            offset += size;
        }
        return flags;
    }
}

