/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.exception;

import org.squirrelframework.foundation.exception.ErrorCodes;

public class SquirrelRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -4324278329515258777L;
    private int errorCodeId;
    private Throwable targetException;
    private String errorMessage;

    public SquirrelRuntimeException(ErrorCodes errorCode) {
        this.errorCodeId = errorCode.getCode();
        this.errorMessage = String.format("%08d : %s.", this.getErrorCodeId(), errorCode.getDescription());
    }

    public SquirrelRuntimeException(Throwable targetException, ErrorCodes errorCode) {
        this(errorCode);
        this.targetException = targetException;
    }

    public SquirrelRuntimeException(ErrorCodes errorCode, Object ... parameters) {
        this.errorCodeId = errorCode.getCode();
        this.errorMessage = String.format("%08d : %s.", this.getErrorCodeId(), String.format(errorCode.getDescription(), parameters));
    }

    public SquirrelRuntimeException(Throwable targetException, ErrorCodes errorCode, Object ... parameters) {
        this(errorCode, parameters);
        this.targetException = targetException;
    }

    public int getErrorCodeId() {
        return this.errorCodeId;
    }

    public Throwable getTargetException() {
        return this.targetException;
    }

    @Override
    public String getMessage() {
        return this.errorMessage;
    }
}

