/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class StateMachinePerformanceModel {
    private String name;
    private long totalTransitionInvokedTimes = 0L;
    private long totalTransitionFailedTimes = 0L;
    private long totalTransitionDeclinedTimes = 0L;
    private float averageTransitionConsumedTime = 0.0f;
    private final Map<String, Long> transitionInvokeTimes = Maps.newHashMap();
    private final Map<String, Float> averTransitionConsumedTime = Maps.newHashMap();
    private final Map<String, Long> maxTransitionConsumedTime = Maps.newHashMap();
    private final Map<String, Long> minTransitionConsumedTime = Maps.newHashMap();
    private long totalActionInvokedTimes = 0L;
    private long totalActionFailedTimes = 0L;
    private float averageActionConsumedTime = 0.0f;
    private final Map<String, Long> actionInvokeTimes = Maps.newHashMap();
    private final Map<String, Float> averActionConsumedTime = Maps.newHashMap();
    private final Map<String, Long> maxActionConsumedTime = Maps.newHashMap();
    private final Map<String, Long> minActionConsumedTime = Maps.newHashMap();

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public long getTotalTransitionInvokedTimes() {
        return this.totalTransitionInvokedTimes;
    }

    void setTotalTransitionInvokedTimes(long totalTransitionInvokedTimes) {
        this.totalTransitionInvokedTimes = totalTransitionInvokedTimes;
    }

    public long getTotalTransitionFailedTimes() {
        return this.totalTransitionFailedTimes;
    }

    void setTotalTransitionFailedTimes(long totalTransitionFailedTimes) {
        this.totalTransitionFailedTimes = totalTransitionFailedTimes;
    }

    public long getTotalTransitionDeclinedTimes() {
        return this.totalTransitionDeclinedTimes;
    }

    void setTotalTransitionDeclinedTimes(long totalTransitionDeclinedTimes) {
        this.totalTransitionDeclinedTimes = totalTransitionDeclinedTimes;
    }

    public float getAverageTransitionConsumedTime() {
        return this.averageTransitionConsumedTime;
    }

    void setAverageTransitionConsumedTime(float averageTransitionConsumedTime) {
        this.averageTransitionConsumedTime = averageTransitionConsumedTime;
    }

    public long getTotalActionInvokedTimes() {
        return this.totalActionInvokedTimes;
    }

    void setTotalActionInvokedTimes(long totalActionInvokedTimes) {
        this.totalActionInvokedTimes = totalActionInvokedTimes;
    }

    public long getTotalActionFailedTimes() {
        return this.totalActionFailedTimes;
    }

    void setTotalActionFailedTimes(long totalActionFailedTimes) {
        this.totalActionFailedTimes = totalActionFailedTimes;
    }

    public float getAverageActionConsumedTime() {
        return this.averageActionConsumedTime;
    }

    void setAverageActionConsumedTime(float averageActionConsumedTime) {
        this.averageActionConsumedTime = averageActionConsumedTime;
    }

    public Map<String, Long> getTransitionInvokeTimes() {
        return Collections.unmodifiableMap(this.transitionInvokeTimes);
    }

    void addTransitionInvokeTime(String key, Long value) {
        this.transitionInvokeTimes.put(key, value);
    }

    public Map<String, Float> getAverTransitionConsumedTime() {
        return Collections.unmodifiableMap(this.averTransitionConsumedTime);
    }

    void addAverTransitionConsumedTime(String key, float value) {
        this.averTransitionConsumedTime.put(key, Float.valueOf(value));
    }

    public Map<String, Long> getMaxTransitionConsumedTime() {
        return Collections.unmodifiableMap(this.maxTransitionConsumedTime);
    }

    void addMaxTransitionConsumedTime(String key, Long value) {
        this.maxTransitionConsumedTime.put(key, value);
    }

    public Map<String, Long> getMinTransitionConsumedTime() {
        return Collections.unmodifiableMap(this.minTransitionConsumedTime);
    }

    void addMinTransitionConsumedTime(String key, Long value) {
        this.minTransitionConsumedTime.put(key, value);
    }

    public Map<String, Long> getActionInvokeTimes() {
        return Collections.unmodifiableMap(this.actionInvokeTimes);
    }

    void addActionInvokeTime(String key, Long value) {
        this.actionInvokeTimes.put(key, value);
    }

    public Map<String, Float> getAverActionConsumedTime() {
        return Collections.unmodifiableMap(this.averActionConsumedTime);
    }

    void addAverActionConsumedTime(String key, float value) {
        this.averActionConsumedTime.put(key, Float.valueOf(value));
    }

    public Map<String, Long> getMaxActionConsumedTime() {
        return Collections.unmodifiableMap(this.maxActionConsumedTime);
    }

    void addMaxActionConsumedTime(String key, Long value) {
        this.maxActionConsumedTime.put(key, value);
    }

    public Map<String, Long> getMinActionConsumedTime() {
        return Collections.unmodifiableMap(this.minActionConsumedTime);
    }

    void addMinActionConsumedTime(String key, Long value) {
        this.minActionConsumedTime.put(key, value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("========================== ");
        builder.append(this.name);
        builder.append(" ==========================\n");
        builder.append("Total Transition Invoked: ").append(this.totalTransitionInvokedTimes).append("\n");
        builder.append("Total Transition Failed: ").append(this.totalTransitionFailedTimes).append("\n");
        builder.append("Total Transition Declained: ").append(this.totalTransitionDeclinedTimes).append("\n");
        builder.append("Average Transition Comsumed: ").append(String.format("%.4fms", Float.valueOf(this.averageTransitionConsumedTime))).append("\n");
        builder.append("\t").append("Transition Key").append("\t\tInvoked Times\tAverage Time\t\tMax Time\tMin Time\n");
        for (String tKey : this.transitionInvokeTimes.keySet()) {
            builder.append("\t").append(StringUtils.abbreviateMiddle((String)tKey, (String)"...", (int)15)).append("\t\t").append(this.transitionInvokeTimes.get(tKey)).append("\t\t").append(String.format("%.4fms", this.averTransitionConsumedTime.get(tKey))).append("\t\t").append(this.maxTransitionConsumedTime.get(tKey)).append("ms\t\t").append(this.minTransitionConsumedTime.get(tKey)).append("ms\t\t");
            builder.append("\n");
        }
        builder.append("\n");
        builder.append("Total Action Invoked: ").append(this.totalActionInvokedTimes).append("\n");
        builder.append("Total Action Failed: ").append(this.totalActionFailedTimes).append("\n");
        builder.append("Average Action Execution Comsumed: ").append(String.format("%.4fms", Float.valueOf(this.averageActionConsumedTime))).append("\n");
        builder.append("\t").append("Action Key").append("\t\tInvoked Times\tAverage Time\t\tMax Time\tMin Time\n");
        for (String aKey : this.actionInvokeTimes.keySet()) {
            builder.append("\t").append(StringUtils.abbreviateMiddle((String)aKey, (String)"...", (int)15)).append("\t\t").append(this.actionInvokeTimes.get(aKey)).append("\t\t").append(String.format("%.4fms", this.averActionConsumedTime.get(aKey))).append("\t\t").append(this.maxActionConsumedTime.get(aKey)).append("ms\t\t").append(this.minActionConsumedTime.get(aKey)).append("ms\t\t");
            builder.append("\n");
        }
        builder.append("========================== ");
        builder.append(this.name);
        builder.append(" ==========================").append("\n");
        return builder.toString();
    }
}

