/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.StateMachinePerformanceModel;
import org.squirrelframework.foundation.fsm.annotation.OnActionExecException;
import org.squirrelframework.foundation.fsm.annotation.OnAfterActionExecuted;
import org.squirrelframework.foundation.fsm.annotation.OnBeforeActionExecuted;
import org.squirrelframework.foundation.fsm.annotation.OnStateMachineStart;
import org.squirrelframework.foundation.fsm.annotation.OnStateMachineTerminate;
import org.squirrelframework.foundation.fsm.annotation.OnTransitionBegin;
import org.squirrelframework.foundation.fsm.annotation.OnTransitionDecline;
import org.squirrelframework.foundation.fsm.annotation.OnTransitionEnd;
import org.squirrelframework.foundation.fsm.annotation.OnTransitionException;

public class StateMachinePerformanceMonitor {
    private final String name;
    private final ConcurrentMap<String, Stopwatch> transitionWatches = Maps.newConcurrentMap();
    private final ConcurrentMap<String, AtomicLong> transitionInvokeTimes = Maps.newConcurrentMap();
    private final ConcurrentMap<String, AtomicLong> transitionFailedTimes = Maps.newConcurrentMap();
    private final ConcurrentMap<String, AtomicLong> transitionDeclinedTimes = Maps.newConcurrentMap();
    private final ConcurrentMap<String, AtomicLong> transitionElapsedMillis = Maps.newConcurrentMap();
    private final ConcurrentMap<String, AtomicLong> maxTransitionConsumedTime = Maps.newConcurrentMap();
    private final ConcurrentMap<String, AtomicLong> minTransitionConsumedTime = Maps.newConcurrentMap();
    private final ConcurrentMap<String, Stopwatch> actionWatches = Maps.newConcurrentMap();
    private final ConcurrentMap<String, AtomicLong> actionInvokeTimes = Maps.newConcurrentMap();
    private final ConcurrentMap<String, AtomicLong> actionFailedTimes = Maps.newConcurrentMap();
    private final ConcurrentMap<String, AtomicLong> actionElapsedMillis = Maps.newConcurrentMap();
    private final ConcurrentMap<String, AtomicLong> maxActionConsumedTime = Maps.newConcurrentMap();
    private final ConcurrentMap<String, AtomicLong> minActionConsumedTime = Maps.newConcurrentMap();
    private final Object waitLock = new Object();
    private volatile boolean isBusyStat = false;

    public StateMachinePerformanceMonitor(String name) {
        this.name = name;
    }

    private String getTransitionKey(Object sourceState, Object targetState, Object event, Object context) {
        return sourceState + "--{" + event + ", " + context + "}->" + targetState;
    }

    private void clearCache() {
        this.transitionInvokeTimes.clear();
        this.transitionFailedTimes.clear();
        this.transitionDeclinedTimes.clear();
        this.transitionElapsedMillis.clear();
        this.maxTransitionConsumedTime.clear();
        this.minTransitionConsumedTime.clear();
        this.actionInvokeTimes.clear();
        this.actionFailedTimes.clear();
        this.actionElapsedMillis.clear();
        this.maxActionConsumedTime.clear();
        this.minActionConsumedTime.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitIfBusyStat() {
        if (this.isBusyStat) {
            Object object = this.waitLock;
            synchronized (object) {
                while (this.isBusyStat) {
                    try {
                        this.waitLock.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllAfterBusyStat() {
        Object object = this.waitLock;
        synchronized (object) {
            this.isBusyStat = false;
            this.waitLock.notifyAll();
        }
    }

    @OnStateMachineStart
    public void onStateMachineStart(StateMachine<?, ?, ?, ?> fsm) {
        this.transitionWatches.put(fsm.getIdentifier(), Stopwatch.createUnstarted());
        this.actionWatches.put(fsm.getIdentifier(), Stopwatch.createUnstarted());
    }

    @OnStateMachineTerminate
    public void onStateMachineTerminate(StateMachine<?, ?, ?, ?> fsm) {
        this.transitionWatches.remove(fsm.getIdentifier());
        this.actionWatches.remove(fsm.getIdentifier());
    }

    @OnTransitionBegin
    public void onTransitionBegin(StateMachine<?, ?, ?, ?> fsm) {
        this.waitIfBusyStat();
        ((Stopwatch)this.transitionWatches.get(fsm.getIdentifier())).reset().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnTransitionEnd
    public void onTransitionEnd(Object sourceState, Object targetState, Object event, Object context, StateMachine<?, ?, ?, ?> fsm) {
        this.waitIfBusyStat();
        String tKey = this.getTransitionKey(sourceState, targetState, event, context);
        long delta = ((Stopwatch)this.transitionWatches.get(fsm.getIdentifier())).stop().elapsed(TimeUnit.MILLISECONDS);
        this.transitionElapsedMillis.putIfAbsent(tKey, new AtomicLong(0L));
        ((AtomicLong)this.transitionElapsedMillis.get(tKey)).addAndGet(delta);
        this.transitionInvokeTimes.putIfAbsent(tKey, new AtomicLong(0L));
        ((AtomicLong)this.transitionInvokeTimes.get(tKey)).incrementAndGet();
        StateMachinePerformanceMonitor stateMachinePerformanceMonitor = this;
        synchronized (stateMachinePerformanceMonitor) {
            if (this.maxTransitionConsumedTime.get(tKey) == null || delta > ((AtomicLong)this.maxTransitionConsumedTime.get(tKey)).get()) {
                this.maxTransitionConsumedTime.put(tKey, new AtomicLong(delta));
            }
            if (this.minTransitionConsumedTime.get(tKey) == null || delta < ((AtomicLong)this.minTransitionConsumedTime.get(tKey)).get()) {
                this.minTransitionConsumedTime.put(tKey, new AtomicLong(delta));
            }
        }
    }

    @OnTransitionException
    public void onTransitionException(Object sourceState, Object targetState, Object event, Object context) {
        this.waitIfBusyStat();
        String tKey = this.getTransitionKey(sourceState, targetState, event, context);
        this.transitionFailedTimes.putIfAbsent(tKey, new AtomicLong(0L));
        ((AtomicLong)this.transitionFailedTimes.get(tKey)).incrementAndGet();
    }

    @OnTransitionDecline
    public void onTransitionDeclined(Object sourceState, Object event, Object context) {
        this.waitIfBusyStat();
        String tKey = this.getTransitionKey(sourceState, null, event, context);
        this.transitionDeclinedTimes.putIfAbsent(tKey, new AtomicLong(0L));
        ((AtomicLong)this.transitionDeclinedTimes.get(tKey)).incrementAndGet();
    }

    @OnBeforeActionExecuted
    public void onBeforeActionExecuted(StateMachine<?, ?, ?, ?> fsm, Action<?, ?, ?, ?> action) {
        this.waitIfBusyStat();
        ((Stopwatch)this.actionWatches.get(fsm.getIdentifier())).reset().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnAfterActionExecuted
    public void onAfterActionExecuted(StateMachine<?, ?, ?, ?> fsm, Action<?, ?, ?, ?> action) {
        this.waitIfBusyStat();
        String aKey = action.toString();
        long delta = ((Stopwatch)this.actionWatches.get(fsm.getIdentifier())).stop().elapsed(TimeUnit.MILLISECONDS);
        this.actionElapsedMillis.putIfAbsent(aKey, new AtomicLong(0L));
        ((AtomicLong)this.actionElapsedMillis.get(aKey)).addAndGet(delta);
        this.actionInvokeTimes.putIfAbsent(aKey, new AtomicLong(0L));
        ((AtomicLong)this.actionInvokeTimes.get(aKey)).incrementAndGet();
        StateMachinePerformanceMonitor stateMachinePerformanceMonitor = this;
        synchronized (stateMachinePerformanceMonitor) {
            if (this.maxActionConsumedTime.get(aKey) == null || delta > ((AtomicLong)this.maxActionConsumedTime.get(aKey)).get()) {
                this.maxActionConsumedTime.put(aKey, new AtomicLong(delta));
            }
            if (this.minActionConsumedTime.get(aKey) == null || delta < ((AtomicLong)this.minActionConsumedTime.get(aKey)).get()) {
                this.minActionConsumedTime.put(aKey, new AtomicLong(delta));
            }
        }
    }

    @OnActionExecException
    public void onActionExecException(Action<?, ?, ?, ?> action) {
        this.waitIfBusyStat();
        String aKey = action.toString();
        this.actionFailedTimes.putIfAbsent(aKey, new AtomicLong(0L));
        ((AtomicLong)this.actionFailedTimes.get(aKey)).incrementAndGet();
    }

    private long getTotal(ConcurrentMap<String, AtomicLong> data) {
        long result = 0L;
        for (AtomicLong value : data.values()) {
            result += value.get();
        }
        return result;
    }

    public synchronized StateMachinePerformanceModel getPerfModel() {
        float averageTime;
        this.isBusyStat = true;
        StateMachinePerformanceModel perfModel = new StateMachinePerformanceModel();
        perfModel.setName(this.name);
        long totalTransitionInvokedTimes = this.getTotal(this.transitionInvokeTimes);
        perfModel.setTotalTransitionInvokedTimes(totalTransitionInvokedTimes);
        long totalTransitionFailedTimes = this.getTotal(this.transitionFailedTimes);
        perfModel.setTotalTransitionFailedTimes(totalTransitionFailedTimes);
        long totalTransitionDeclinedTimes = this.getTotal(this.transitionDeclinedTimes);
        perfModel.setTotalTransitionDeclinedTimes(totalTransitionDeclinedTimes);
        long totalTransitionConsumedTime = this.getTotal(this.transitionElapsedMillis);
        float averageTranstionConsumedTime = (float)totalTransitionConsumedTime / ((float)totalTransitionInvokedTimes + Float.MIN_VALUE);
        perfModel.setAverageTransitionConsumedTime(averageTranstionConsumedTime);
        long totalActionInvokedTimes = this.getTotal(this.actionInvokeTimes);
        perfModel.setTotalActionInvokedTimes(totalActionInvokedTimes);
        long totalActionFailedTimes = this.getTotal(this.actionFailedTimes);
        perfModel.setTotalActionFailedTimes(totalActionFailedTimes);
        long totalActionConsumedTime = this.getTotal(this.actionElapsedMillis);
        float averageActionConsumedTime = (float)totalActionConsumedTime / ((float)totalActionInvokedTimes + Float.MIN_VALUE);
        perfModel.setAverageActionConsumedTime(averageActionConsumedTime);
        for (String tKey : this.transitionInvokeTimes.keySet()) {
            averageTime = (float)((AtomicLong)this.transitionElapsedMillis.get(tKey)).get() / ((float)((AtomicLong)this.transitionInvokeTimes.get(tKey)).get() + Float.MIN_VALUE);
            perfModel.addAverTransitionConsumedTime(tKey, averageTime);
            perfModel.addTransitionInvokeTime(tKey, ((AtomicLong)this.transitionInvokeTimes.get(tKey)).get());
            perfModel.addMaxTransitionConsumedTime(tKey, ((AtomicLong)this.maxTransitionConsumedTime.get(tKey)).get());
            perfModel.addMinTransitionConsumedTime(tKey, ((AtomicLong)this.minTransitionConsumedTime.get(tKey)).get());
        }
        for (String aKey : this.actionInvokeTimes.keySet()) {
            averageTime = (float)((AtomicLong)this.actionElapsedMillis.get(aKey)).get() / ((float)((AtomicLong)this.actionInvokeTimes.get(aKey)).get() + Float.MIN_VALUE);
            perfModel.addAverActionConsumedTime(aKey, averageTime);
            perfModel.addActionInvokeTime(aKey, ((AtomicLong)this.actionInvokeTimes.get(aKey)).get());
            perfModel.addMaxActionConsumedTime(aKey, ((AtomicLong)this.maxActionConsumedTime.get(aKey)).get());
            perfModel.addMinActionConsumedTime(aKey, ((AtomicLong)this.minActionConsumedTime.get(aKey)).get());
        }
        this.clearCache();
        this.notifyAllAfterBusyStat();
        return perfModel;
    }
}

