/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.squirrelframework.foundation.component.SquirrelComponent;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.ActionWrapper;
import org.squirrelframework.foundation.fsm.Condition;
import org.squirrelframework.foundation.fsm.Conditions;
import org.squirrelframework.foundation.fsm.MethodReference;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.builder.DeferBoundActionBuilder;
import org.squirrelframework.foundation.fsm.builder.DeferBoundActionFrom;
import org.squirrelframework.foundation.fsm.builder.DeferBoundActionTo;
import org.squirrelframework.foundation.fsm.builder.On;
import org.squirrelframework.foundation.fsm.builder.When;
import org.squirrelframework.foundation.fsm.impl.DeferBoundActionInfo;
import org.squirrelframework.foundation.fsm.impl.ExecutionContext;
import org.squirrelframework.foundation.fsm.impl.FSM;
import org.squirrelframework.foundation.fsm.impl.MethodCallActionProxyImpl;
import org.squirrelframework.foundation.fsm.impl.MethodReferenceActionImpl;

public class DeferBoundActionBuilderImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements DeferBoundActionBuilder<T, S, E, C>,
DeferBoundActionFrom<T, S, E, C>,
DeferBoundActionTo<T, S, E, C>,
On<T, S, E, C>,
SquirrelComponent {
    private final List<DeferBoundActionInfo<T, S, E, C>> deferBoundActionInfoList;
    private final ExecutionContext executionContext;
    private S from;
    private S to;
    private DeferBoundActionInfo<T, S, E, C> deferBoundActionInfo;
    private Condition<C> condition;

    DeferBoundActionBuilderImpl(List<DeferBoundActionInfo<T, S, E, C>> deferBoundActionInfoList, ExecutionContext executionContext) {
        this.deferBoundActionInfoList = deferBoundActionInfoList;
        this.executionContext = executionContext;
    }

    @Override
    public void perform(Action<T, S, E, C> action) {
        if (this.condition == null) {
            this.deferBoundActionInfo.setActions(Collections.singletonList(action));
        } else {
            this.deferBoundActionInfo.setActions(Collections.singletonList(this.warpConditionalAction(action)));
        }
    }

    @Override
    public void perform(List<? extends Action<T, S, E, C>> actions) {
        if (this.condition == null) {
            this.deferBoundActionInfo.setActions(actions);
        } else {
            List wrapActions = Lists.transform(actions, (Function)new Function<Action<T, S, E, C>, Action<T, S, E, C>>(){

                public Action<T, S, E, C> apply(Action<T, S, E, C> action) {
                    return DeferBoundActionBuilderImpl.this.warpConditionalAction(action);
                }
            });
            this.deferBoundActionInfo.setActions(wrapActions);
        }
    }

    @Override
    public void evalMvel(String expression) {
        Action action = FSM.newMvelAction(expression, this.executionContext);
        this.perform(action);
    }

    @Override
    public void callMethod(String methodName) {
        MethodCallActionProxyImpl action = FSM.newMethodCallActionProxy(methodName, this.executionContext);
        this.perform(action);
    }

    @Override
    public void invokeMethod(MethodReference<T, S, E, C> methodReference) {
        MethodReferenceActionImpl<T, S, E, C> action = FSM.newMethodReferenceAction(methodReference);
        this.perform(action);
    }

    @Override
    public On<T, S, E, C> on(E event) {
        this.deferBoundActionInfo = new DeferBoundActionInfo(this.from, this.to, event);
        this.deferBoundActionInfoList.add(this.deferBoundActionInfo);
        return this;
    }

    @Override
    public On<T, S, E, C> onAny() {
        this.deferBoundActionInfo = new DeferBoundActionInfo(this.from, this.to, null);
        this.deferBoundActionInfoList.add(this.deferBoundActionInfo);
        return this;
    }

    @Override
    public DeferBoundActionTo<T, S, E, C> to(S to) {
        this.to = to;
        return this;
    }

    @Override
    public DeferBoundActionTo<T, S, E, C> toAny() {
        return this;
    }

    @Override
    public DeferBoundActionFrom<T, S, E, C> fromAny() {
        return this;
    }

    @Override
    public DeferBoundActionFrom<T, S, E, C> from(S from) {
        this.from = from;
        return this;
    }

    @Override
    public When<T, S, E, C> when(Condition<C> condition) {
        this.condition = condition;
        return this;
    }

    @Override
    public When<T, S, E, C> whenMvel(String expression) {
        this.condition = FSM.newMvelCondition(expression, this.executionContext.getScriptManager());
        return this;
    }

    private Action<T, S, E, C> warpConditionalAction(Action<T, S, E, C> action) {
        return new ActionWrapper<T, S, E, C>(action){

            @Override
            public void execute(S from, S to, E event, C context, T stateMachine) {
                if (Conditions.isSatified(DeferBoundActionBuilderImpl.this.condition, context)) {
                    super.execute(from, to, event, context, stateMachine);
                }
            }
        };
    }
}

