/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.StringUtils;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.Condition;
import org.squirrelframework.foundation.fsm.Conditions;
import org.squirrelframework.foundation.fsm.Converter;
import org.squirrelframework.foundation.fsm.ConverterProvider;
import org.squirrelframework.foundation.fsm.HistoryType;
import org.squirrelframework.foundation.fsm.MutableState;
import org.squirrelframework.foundation.fsm.StateCompositeType;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.StateMachineBuilder;
import org.squirrelframework.foundation.fsm.StateMachineBuilderFactory;
import org.squirrelframework.foundation.fsm.StateMachineImporter;
import org.squirrelframework.foundation.fsm.impl.StateMachineBuilderImpl;
import org.squirrelframework.foundation.fsm.impl.TransitionBuilderImpl;
import org.squirrelframework.foundation.util.ReflectUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StateMachineImporterImpl<T extends StateMachine<T, S, E, C>, S, E, C>
extends DefaultHandler
implements StateMachineImporter<T, S, E, C> {
    public static String SQRL_NAMESPACE = "http://squirrelframework.org/squirrel";
    public static String SCXML_NAMESPACE = "http://www.w3.org/2005/07/scxml";
    protected String value = "";
    protected String sqrlPrefix = "";
    protected Converter<S> stateConverter;
    protected Converter<E> eventConverter;
    protected StateMachineBuilder<T, S, E, C> stateMachineBuilder;
    protected final Stack<MutableState<T, S, E, C>> currentStates = new Stack();
    protected TransitionBuilderImpl<T, S, E, C> currentTranstionBuilder;
    protected final ListMultimap<MutableState<T, S, E, C>, MutableState<T, S, E, C>> hierarchicalStateStore = ArrayListMultimap.create();
    protected Boolean isEntryAction;
    protected final Map<String, Object> reusableInstance = Maps.newHashMap();

    public StateMachineImporterImpl() {
        this.registerReusableInstance(Conditions.always());
        this.registerReusableInstance(Conditions.never());
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (uri.equals(SQRL_NAMESPACE)) {
            this.sqrlPrefix = prefix;
        }
    }

    @Override
    public void characters(char[] buffer, int start, int length) {
        this.value = new String(buffer, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.equals("fsm") && uri.equals(SQRL_NAMESPACE)) {
            String terminateEventName;
            String startEventName;
            String fsmType = attributes.getValue("fsm-type");
            Class<?> stateMachineClazz = ReflectUtils.getClass(fsmType);
            Preconditions.checkNotNull(stateMachineClazz);
            String stateType = attributes.getValue("state-type");
            Class<?> stateClazz = ReflectUtils.getClass(stateType);
            Preconditions.checkNotNull(stateClazz);
            this.stateConverter = ConverterProvider.INSTANCE.getConverter(stateClazz);
            Preconditions.checkNotNull(this.stateConverter);
            String eventType = attributes.getValue("event-type");
            Class<?> eventClazz = ReflectUtils.getClass(eventType);
            Preconditions.checkNotNull(eventClazz);
            this.eventConverter = ConverterProvider.INSTANCE.getConverter(eventClazz);
            Preconditions.checkNotNull(this.eventConverter);
            String contextType = attributes.getValue("context-type");
            Class<?> contextClazz = ReflectUtils.getClass(contextType);
            Preconditions.checkNotNull(contextClazz);
            String extraParams = attributes.getValue("extra-parameters");
            Class[] extraParamTypes = new Class[]{};
            if (extraParams != null && extraParams.length() > 2) {
                String[] typeNames = StringUtils.split((String)extraParams.substring(1, extraParams.length() - 1), (char)',');
                extraParamTypes = new Class[typeNames.length];
                for (int i = 0; i < typeNames.length; ++i) {
                    extraParamTypes[i] = ReflectUtils.getClass(typeNames[i]);
                }
            }
            this.stateMachineBuilder = StateMachineBuilderFactory.create(stateMachineClazz, stateClazz, eventClazz, contextClazz, extraParamTypes);
            ((StateMachineBuilderImpl)this.stateMachineBuilder).setScanAnnotations(false);
            String finishEventName = attributes.getValue("finish-event");
            if (finishEventName != null) {
                E finishEvent = this.eventConverter.convertFromString(finishEventName);
                this.stateMachineBuilder.defineFinishEvent(finishEvent);
            }
            if ((startEventName = attributes.getValue("start-event")) != null) {
                E startEvent = this.eventConverter.convertFromString(startEventName);
                this.stateMachineBuilder.defineStartEvent(startEvent);
            }
            if ((terminateEventName = attributes.getValue("terminate-event")) != null) {
                E terminateEvent = this.eventConverter.convertFromString(terminateEventName);
                this.stateMachineBuilder.defineTerminateEvent(terminateEvent);
            }
            this.currentStates.clear();
            this.currentTranstionBuilder = null;
        } else if (qName.equals("state") || qName.equals("final") || qName.equals("parallel")) {
            MutableState<T, S, E, C> parentState = null;
            if (this.currentStates.size() > 0) {
                parentState = this.getCurrentState();
            }
            String stateIdName = attributes.getValue("id");
            S stateId = this.stateConverter.convertFromString(stateIdName);
            if (qName.equals("final")) {
                this.currentStates.push(this.stateMachineBuilder.defineFinalState(stateId));
            } else {
                this.currentStates.push(this.stateMachineBuilder.defineState(stateId));
                if (qName.equals("parallel")) {
                    this.getCurrentState().setCompositeType(StateCompositeType.PARALLEL);
                }
            }
            String initStateIdName = attributes.getValue("initial");
            if (initStateIdName != null) {
                S initStateId = this.stateConverter.convertFromString(initStateIdName);
                this.getCurrentState().setInitialState(this.stateMachineBuilder.defineState(initStateId));
            }
            if (parentState != null) {
                this.hierarchicalStateStore.put(parentState, this.getCurrentState());
            }
        } else if (qName.equals("history")) {
            String historyType = attributes.getValue("type");
            if (historyType.equals("deep")) {
                this.getCurrentState().setHistoryType(HistoryType.DEEP);
            } else if (historyType.equals("shallow")) {
                this.getCurrentState().setHistoryType(HistoryType.SHALLOW);
            }
        } else if (qName.equals("onentry")) {
            this.isEntryAction = Boolean.TRUE;
        } else if (qName.equals("onexit")) {
            this.isEntryAction = Boolean.FALSE;
        } else if (localName.equals("action") && uri.equals(SQRL_NAMESPACE)) {
            String actionContent = attributes.getValue("content");
            int pos = actionContent.indexOf("#");
            String actionSchema = actionContent.substring(0, pos);
            String _tmp = actionContent.substring(pos + 1);
            pos = _tmp.indexOf(":");
            String actionValue = _tmp;
            String actionWeightValue = "";
            if (pos > 0) {
                actionValue = _tmp.substring(0, pos);
                actionWeightValue = _tmp.substring(pos + 1);
            }
            if (actionSchema.equals("method")) {
                String methodCallDesc = actionValue + ":" + actionWeightValue;
                if (this.isConstructState()) {
                    if (Boolean.TRUE == this.isEntryAction) {
                        this.stateMachineBuilder.onEntry(this.getCurrentState().getStateId()).callMethod(methodCallDesc);
                    } else {
                        this.stateMachineBuilder.onExit(this.getCurrentState().getStateId()).callMethod(methodCallDesc);
                    }
                } else if (this.isConstructTransition()) {
                    this.getCurrentTranstionBuilder().callMethod(methodCallDesc);
                }
            } else if (actionSchema.equals("instance")) {
                Action action = (Action)this.newInstance(actionValue);
                if (this.isConstructState()) {
                    if (Boolean.TRUE == this.isEntryAction) {
                        this.stateMachineBuilder.onEntry(this.getCurrentState().getStateId()).perform(action);
                    } else if (Boolean.FALSE == this.isEntryAction) {
                        this.stateMachineBuilder.onExit(this.getCurrentState().getStateId()).perform(action);
                    }
                } else if (this.isConstructTransition()) {
                    this.getCurrentTranstionBuilder().perform(action);
                }
            } else if (actionSchema.equals("mvel")) {
                if (this.isConstructState()) {
                    if (Boolean.TRUE == this.isEntryAction) {
                        this.stateMachineBuilder.onEntry(this.getCurrentState().getStateId()).evalMvel(actionValue);
                    } else if (Boolean.FALSE == this.isEntryAction) {
                        this.stateMachineBuilder.onExit(this.getCurrentState().getStateId()).evalMvel(actionValue);
                    }
                } else if (this.isConstructTransition()) {
                    this.getCurrentTranstionBuilder().evalMvel(actionValue);
                }
            }
        } else if (qName.equals("transition")) {
            String eventName = attributes.getValue("event");
            E event = this.eventConverter.convertFromString(eventName);
            String targetState = attributes.getValue("target");
            S targetStateId = this.stateConverter.convertFromString(targetState);
            String transitionType = attributes.getValue(SQRL_NAMESPACE, "type");
            Integer transitionPriority = 1;
            try {
                transitionPriority = Integer.valueOf(attributes.getValue(SQRL_NAMESPACE, "priority"));
            }
            catch (NumberFormatException action) {
                // empty catch block
            }
            TransitionBuilderImpl builder = null;
            builder = transitionType.equals("INTERNAL") ? (TransitionBuilderImpl)this.stateMachineBuilder.internalTransition(transitionPriority) : (transitionType.equals("LOCAL") ? (TransitionBuilderImpl)this.stateMachineBuilder.localTransition(transitionPriority) : (TransitionBuilderImpl)this.stateMachineBuilder.externalTransition(transitionPriority));
            this.currentTranstionBuilder = builder;
            this.getCurrentTranstionBuilder().from(this.getCurrentState().getStateId()).to(targetStateId).on(event);
            String conditionScript = attributes.getValue("cond");
            int condPos = conditionScript.indexOf("#");
            String condSchema = conditionScript.substring(0, condPos);
            String condContent = conditionScript.substring(condPos + 1);
            if (condSchema.equals("instance")) {
                Condition cond = (Condition)this.newInstance(condContent);
                this.getCurrentTranstionBuilder().when(cond);
            } else if (condSchema.equals("mvel")) {
                this.getCurrentTranstionBuilder().whenMvel(condContent);
            }
        }
    }

    protected boolean isConstructState() {
        return this.currentStates.size() > 0 && this.currentTranstionBuilder == null && this.isEntryAction != null;
    }

    protected boolean isConstructTransition() {
        return this.currentStates.size() > 0 && this.currentTranstionBuilder != null && this.isEntryAction == null;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("onentry") || qName.equals("onexit")) {
            this.isEntryAction = null;
        } else if (qName.equals("state") || qName.equals("final") || qName.equals("parallel")) {
            MutableState<T, S, E, C> currentState = this.currentStates.pop();
            List subStates = this.hierarchicalStateStore.removeAll(currentState);
            if (!subStates.isEmpty()) {
                for (MutableState subState : subStates) {
                    subState.setParentState(currentState);
                    currentState.addChildState(subState);
                }
            }
        } else if (qName.equals("transition")) {
            this.currentTranstionBuilder = null;
        }
    }

    private <M> M newInstance(String instanceClassName) {
        Object instance = this.reusableInstance.get(instanceClassName);
        if (instance == null) {
            instance = ReflectUtils.newInstance(instanceClassName);
        }
        return (M)instance;
    }

    protected MutableState<T, S, E, C> getCurrentState() {
        return this.currentStates.peek();
    }

    protected TransitionBuilderImpl<T, S, E, C> getCurrentTranstionBuilder() {
        return this.currentTranstionBuilder;
    }

    @Override
    public StateMachineBuilder<T, S, E, C> importFromInputStream(InputStream content) {
        SAXParserFactory spfac = SAXParserFactory.newInstance();
        spfac.setNamespaceAware(true);
        try {
            SAXParser sp = spfac.newSAXParser();
            sp.parse(content, (DefaultHandler)this);
            return this.stateMachineBuilder;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Incorrect content format.", e);
        }
    }

    @Override
    public StateMachineBuilder<T, S, E, C> importFromString(String content) {
        return this.importFromInputStream(new ByteArrayInputStream(content.getBytes()));
    }

    @Override
    public StateMachineBuilder<T, S, E, C> importFromFile(File content) {
        try {
            return this.importFromInputStream(new FileInputStream(content));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Canont find file", e);
        }
    }

    @Override
    public void registerReusableInstance(Object instance) {
        this.registerReusableInstance(instance.getClass().getName(), instance);
    }

    @Override
    public void unregisterReusableInstance(String instanceName) {
        this.reusableInstance.remove(instanceName);
    }

    @Override
    public void registerReusableInstance(String instanceName, Object instance) {
        this.reusableInstance.put(instanceName, instance);
    }
}

