/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import java.util.List;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.Actions;
import org.squirrelframework.foundation.fsm.Condition;
import org.squirrelframework.foundation.fsm.Conditions;
import org.squirrelframework.foundation.fsm.ImmutableState;
import org.squirrelframework.foundation.fsm.MutableTransition;
import org.squirrelframework.foundation.fsm.StateContext;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.TransitionType;
import org.squirrelframework.foundation.fsm.Visitor;
import org.squirrelframework.foundation.fsm.impl.FSM;

class TransitionImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements MutableTransition<T, S, E, C> {
    private ImmutableState<T, S, E, C> sourceState;
    private ImmutableState<T, S, E, C> targetState;
    private E event;
    private final Actions<T, S, E, C> actions = FSM.newActions();
    private Condition<C> condition = Conditions.always();
    private TransitionType type = TransitionType.EXTERNAL;
    private int priority;

    TransitionImpl() {
    }

    @Override
    public ImmutableState<T, S, E, C> getSourceState() {
        return this.sourceState;
    }

    @Override
    public ImmutableState<T, S, E, C> getTargetState() {
        return this.targetState;
    }

    @Override
    public List<Action<T, S, E, C>> getActions() {
        return this.actions.getAll();
    }

    @Override
    public ImmutableState<T, S, E, C> transit(StateContext<T, S, E, C> stateContext) {
        stateContext.getExecutor().begin("TRANSITION__" + this.toString());
        for (Action<T, S, E, C> action : this.getActions()) {
            stateContext.getExecutor().defer(action, this.sourceState.getStateId(), this.targetState.getStateId(), stateContext.getEvent(), stateContext.getContext(), stateContext.getStateMachine().getThis());
        }
        return this.targetState;
    }

    @Override
    public void setSourceState(ImmutableState<T, S, E, C> state) {
        this.sourceState = state;
    }

    @Override
    public void setTargetState(ImmutableState<T, S, E, C> state) {
        this.targetState = state;
    }

    @Override
    public void addAction(Action<T, S, E, C> newAction) {
        this.actions.add(newAction);
    }

    @Override
    public void addActions(List<? extends Action<T, S, E, C>> newActions) {
        this.actions.addAll(newActions);
    }

    @Override
    public Condition<C> getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(Condition<C> condition) {
        this.condition = condition;
    }

    @Override
    public E getEvent() {
        return this.event;
    }

    @Override
    public void setEvent(E event) {
        this.event = event;
    }

    @Override
    public TransitionType getType() {
        return this.type;
    }

    @Override
    public void setType(TransitionType type) {
        this.type = type;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    private void doTransit(ImmutableState<T, S, E, C> source, ImmutableState<T, S, E, C> target, StateContext<T, S, E, C> stateContext) {
        if (target.isChildStateOf(source) && this.type == TransitionType.EXTERNAL) {
            source.exit(stateContext);
            source.entry(stateContext);
        }
        this.doTransitInternal(source, target, stateContext);
    }

    private void doTransitInternal(ImmutableState<T, S, E, C> source, ImmutableState<T, S, E, C> target, StateContext<T, S, E, C> stateContext) {
        if (source == this.getTargetState()) {
            if (this.type == TransitionType.LOCAL) {
                this.transit(stateContext);
            } else {
                source.exit(stateContext);
                this.transit(stateContext);
                this.getTargetState().entry(stateContext);
            }
        } else if (source == target) {
            this.transit(stateContext);
        } else if (source.getParentState() == target.getParentState()) {
            source.exit(stateContext);
            this.transit(stateContext);
            target.entry(stateContext);
        } else if (source.getLevel() > target.getLevel()) {
            source.exit(stateContext);
            this.doTransitInternal(source.getParentState(), target, stateContext);
        } else if (source.getLevel() < target.getLevel()) {
            this.doTransitInternal(source, target.getParentState(), stateContext);
            target.entry(stateContext);
        } else {
            source.exit(stateContext);
            this.doTransitInternal(source.getParentState(), target.getParentState(), stateContext);
            target.entry(stateContext);
        }
    }

    @Override
    public void internalFire(StateContext<T, S, E, C> stateContext) {
        if (this.type == TransitionType.INTERNAL && stateContext.getSourceState().getStateId() != this.targetState.getStateId()) {
            return;
        }
        if (this.condition.isSatisfied(stateContext.getContext())) {
            ImmutableState<T, S, E, C> newState = stateContext.getSourceState();
            if (this.type == TransitionType.INTERNAL) {
                newState = this.transit(stateContext);
            } else {
                this.unwindSubStates(stateContext.getSourceState(), stateContext);
                this.doTransit(this.getSourceState(), this.getTargetState(), stateContext);
                newState = this.getTargetState().enterByHistory(stateContext);
            }
            stateContext.getResult().setAccepted(true).setTargetState(newState);
        }
    }

    private void unwindSubStates(ImmutableState<T, S, E, C> orgState, StateContext<T, S, E, C> stateContext) {
        for (ImmutableState<T, S, E, C> state = orgState; state != this.getSourceState(); state = state.getParentState()) {
            if (state == null) continue;
            state.exit(stateContext);
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitOnEntry(this);
        visitor.visitOnExit(this);
    }

    @Override
    public boolean isMatch(S fromState, S toState, E event, int priority) {
        if (toState == null) {
            return false;
        }
        if (toState != null && !this.getTargetState().getStateId().equals(toState)) {
            return false;
        }
        if (!this.getEvent().equals(event)) {
            return false;
        }
        return this.getPriority() == priority;
    }

    @Override
    public boolean isMatch(S fromState, S toState, E event, int priority, Class<?> condClazz, TransitionType type) {
        if (!this.isMatch(fromState, toState, event, priority)) {
            return false;
        }
        if (this.getCondition().getClass() != condClazz) {
            return false;
        }
        return this.getType().equals((Object)type);
    }

    public final String toString() {
        return this.sourceState + "-[" + this.event.toString() + ", " + this.condition.name() + ", " + this.priority + ", " + (Object)((Object)this.type) + "]->" + this.targetState;
    }

    @Override
    public void verify() {
        if (this.type == TransitionType.INTERNAL && this.sourceState != this.targetState) {
            throw new RuntimeException(String.format("Internal transition source state '%s' and target state '%s' must be same.", this.sourceState, this.targetState));
        }
    }
}

