/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool;

import java.util.List;
import org.tarantool.Code;
import org.tarantool.Iterator;
import org.tarantool.Key;
import org.tarantool.TarantoolClientOps;
import org.tarantool.TarantoolRequest;
import org.tarantool.TarantoolRequestArgumentFactory;
import org.tarantool.schema.TarantoolSchemaMeta;

public abstract class AbstractTarantoolOps<Result>
implements TarantoolClientOps<Integer, List<?>, Object, Result> {
    private Code callCode = Code.CALL;

    protected abstract Result exec(TarantoolRequest var1);

    protected abstract TarantoolSchemaMeta getSchemaMeta();

    @Override
    public Result select(Integer space, Integer index, List<?> key, int offset, int limit, Iterator iterator) {
        return this.select(space, index, key, offset, limit, iterator.getValue());
    }

    @Override
    public Result select(String space, String index, List<?> key, int offset, int limit, Iterator iterator) {
        return this.select(space, index, key, offset, limit, iterator.getValue());
    }

    @Override
    public Result select(Integer space, Integer index, List<?> key, int offset, int limit, int iterator) {
        return this.exec(new TarantoolRequest(Code.SELECT, TarantoolRequestArgumentFactory.value(Key.SPACE), TarantoolRequestArgumentFactory.value(space), TarantoolRequestArgumentFactory.value(Key.INDEX), TarantoolRequestArgumentFactory.value(index), TarantoolRequestArgumentFactory.value(Key.KEY), TarantoolRequestArgumentFactory.value(key), TarantoolRequestArgumentFactory.value(Key.ITERATOR), TarantoolRequestArgumentFactory.value(iterator), TarantoolRequestArgumentFactory.value(Key.LIMIT), TarantoolRequestArgumentFactory.value(limit), TarantoolRequestArgumentFactory.value(Key.OFFSET), TarantoolRequestArgumentFactory.value(offset)));
    }

    @Override
    public Result select(String space, String index, List<?> key, int offset, int limit, int iterator) {
        return this.exec(new TarantoolRequest(Code.SELECT, TarantoolRequestArgumentFactory.value(Key.SPACE), TarantoolRequestArgumentFactory.cacheLookupValue(() -> this.getSchemaMeta().getSpace(space).getId()), TarantoolRequestArgumentFactory.value(Key.INDEX), TarantoolRequestArgumentFactory.cacheLookupValue(() -> this.getSchemaMeta().getSpaceIndex(space, index).getId()), TarantoolRequestArgumentFactory.value(Key.KEY), TarantoolRequestArgumentFactory.value(key), TarantoolRequestArgumentFactory.value(Key.ITERATOR), TarantoolRequestArgumentFactory.value(iterator), TarantoolRequestArgumentFactory.value(Key.LIMIT), TarantoolRequestArgumentFactory.value(limit), TarantoolRequestArgumentFactory.value(Key.OFFSET), TarantoolRequestArgumentFactory.value(offset)));
    }

    @Override
    public Result insert(Integer space, List<?> tuple) {
        return this.exec(new TarantoolRequest(Code.INSERT, TarantoolRequestArgumentFactory.value(Key.SPACE), TarantoolRequestArgumentFactory.value(space), TarantoolRequestArgumentFactory.value(Key.TUPLE), TarantoolRequestArgumentFactory.value(tuple)));
    }

    @Override
    public Result insert(String space, List<?> tuple) {
        return this.exec(new TarantoolRequest(Code.INSERT, TarantoolRequestArgumentFactory.value(Key.SPACE), TarantoolRequestArgumentFactory.cacheLookupValue(() -> this.getSchemaMeta().getSpace(space).getId()), TarantoolRequestArgumentFactory.value(Key.TUPLE), TarantoolRequestArgumentFactory.value(tuple)));
    }

    @Override
    public Result replace(Integer space, List<?> tuple) {
        return this.exec(new TarantoolRequest(Code.REPLACE, TarantoolRequestArgumentFactory.value(Key.SPACE), TarantoolRequestArgumentFactory.value(space), TarantoolRequestArgumentFactory.value(Key.TUPLE), TarantoolRequestArgumentFactory.value(tuple)));
    }

    @Override
    public Result replace(String space, List<?> tuple) {
        return this.exec(new TarantoolRequest(Code.REPLACE, TarantoolRequestArgumentFactory.value(Key.SPACE), TarantoolRequestArgumentFactory.cacheLookupValue(() -> this.getSchemaMeta().getSpace(space).getId()), TarantoolRequestArgumentFactory.value(Key.TUPLE), TarantoolRequestArgumentFactory.value(tuple)));
    }

    @Override
    public Result update(Integer space, List<?> key, Object ... operations) {
        return this.exec(new TarantoolRequest(Code.UPDATE, TarantoolRequestArgumentFactory.value(Key.SPACE), TarantoolRequestArgumentFactory.value(space), TarantoolRequestArgumentFactory.value(Key.KEY), TarantoolRequestArgumentFactory.value(key), TarantoolRequestArgumentFactory.value(Key.TUPLE), TarantoolRequestArgumentFactory.value(operations)));
    }

    @Override
    public Result update(String space, List<?> key, Object ... operations) {
        return this.exec(new TarantoolRequest(Code.UPDATE, TarantoolRequestArgumentFactory.value(Key.SPACE), TarantoolRequestArgumentFactory.cacheLookupValue(() -> this.getSchemaMeta().getSpace(space).getId()), TarantoolRequestArgumentFactory.value(Key.KEY), TarantoolRequestArgumentFactory.value(key), TarantoolRequestArgumentFactory.value(Key.TUPLE), TarantoolRequestArgumentFactory.value(operations)));
    }

    @Override
    public Result upsert(Integer space, List<?> key, List<?> defTuple, Object ... operations) {
        return this.exec(new TarantoolRequest(Code.UPSERT, TarantoolRequestArgumentFactory.value(Key.SPACE), TarantoolRequestArgumentFactory.value(space), TarantoolRequestArgumentFactory.value(Key.KEY), TarantoolRequestArgumentFactory.value(key), TarantoolRequestArgumentFactory.value(Key.TUPLE), TarantoolRequestArgumentFactory.value(defTuple), TarantoolRequestArgumentFactory.value(Key.UPSERT_OPS), TarantoolRequestArgumentFactory.value(operations)));
    }

    @Override
    public Result upsert(String space, List<?> key, List<?> defTuple, Object ... operations) {
        return this.exec(new TarantoolRequest(Code.UPSERT, TarantoolRequestArgumentFactory.value(Key.SPACE), TarantoolRequestArgumentFactory.cacheLookupValue(() -> this.getSchemaMeta().getSpace(space).getId()), TarantoolRequestArgumentFactory.value(Key.KEY), TarantoolRequestArgumentFactory.value(key), TarantoolRequestArgumentFactory.value(Key.TUPLE), TarantoolRequestArgumentFactory.value(defTuple), TarantoolRequestArgumentFactory.value(Key.UPSERT_OPS), TarantoolRequestArgumentFactory.value(operations)));
    }

    @Override
    public Result delete(Integer space, List<?> key) {
        return this.exec(new TarantoolRequest(Code.DELETE, TarantoolRequestArgumentFactory.value(Key.SPACE), TarantoolRequestArgumentFactory.value(space), TarantoolRequestArgumentFactory.value(Key.KEY), TarantoolRequestArgumentFactory.value(key)));
    }

    @Override
    public Result delete(String space, List<?> key) {
        return this.exec(new TarantoolRequest(Code.DELETE, TarantoolRequestArgumentFactory.value(Key.SPACE), TarantoolRequestArgumentFactory.cacheLookupValue(() -> this.getSchemaMeta().getSpace(space).getId()), TarantoolRequestArgumentFactory.value(Key.KEY), TarantoolRequestArgumentFactory.value(key)));
    }

    @Override
    public Result call(String function, Object ... args) {
        return this.exec(new TarantoolRequest(this.callCode, TarantoolRequestArgumentFactory.value(Key.FUNCTION), TarantoolRequestArgumentFactory.value(function), TarantoolRequestArgumentFactory.value(Key.TUPLE), TarantoolRequestArgumentFactory.value(args)));
    }

    @Override
    public Result eval(String expression, Object ... args) {
        return this.exec(new TarantoolRequest(Code.EVAL, TarantoolRequestArgumentFactory.value(Key.EXPRESSION), TarantoolRequestArgumentFactory.value(expression), TarantoolRequestArgumentFactory.value(Key.TUPLE), TarantoolRequestArgumentFactory.value(args)));
    }

    @Override
    public void ping() {
        this.exec(new TarantoolRequest(Code.PING));
    }

    public void setCallCode(Code callCode) {
        this.callCode = callCode;
    }
}

