/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.tarantool.ConfigurableSocketChannelProvider;
import org.tarantool.SocketProviderTransientException;

public abstract class BaseSocketChannelProvider
implements ConfigurableSocketChannelProvider {
    private int retriesLimit = 0;
    private int connectionTimeout = 0;

    @Override
    public final SocketChannel get(int retryNumber, Throwable lastError) {
        try {
            return this.makeAttempt(retryNumber, lastError);
        }
        catch (IOException e) {
            throw new SocketProviderTransientException("Couldn't connect to the server", e);
        }
    }

    protected abstract SocketChannel makeAttempt(int var1, Throwable var2) throws IOException;

    @Override
    public void setRetriesLimit(int retriesLimit) {
        if (retriesLimit < 0) {
            throw new IllegalArgumentException("Retries count cannot be negative.");
        }
        this.retriesLimit = retriesLimit;
    }

    public int getRetriesLimit() {
        return this.retriesLimit;
    }

    protected InetSocketAddress parseAddress(String address) {
        int separatorPosition = address.indexOf(58);
        String host = separatorPosition < 0 ? address : address.substring(0, separatorPosition);
        int port = separatorPosition < 0 ? 3301 : Integer.parseInt(address.substring(separatorPosition + 1));
        return new InetSocketAddress(host, port);
    }

    protected SocketChannel openChannel(InetSocketAddress socketAddress) throws IOException {
        SocketChannel channel = null;
        try {
            channel = SocketChannel.open();
            channel.socket().connect(socketAddress, this.connectionTimeout);
            return channel;
        }
        catch (IOException e) {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(int connectionTimeout) {
        if (connectionTimeout < 0) {
            throw new IllegalArgumentException("Connection timeout cannot be negative.");
        }
        this.connectionTimeout = connectionTimeout;
    }
}

