/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import org.tarantool.CommunicationException;
import org.tarantool.CountInputStream;

public class ByteBufferInputStream
extends CountInputStream {
    protected final SocketChannel channel;
    protected final ByteBuffer buffer;
    protected final Selector selector = SelectorProvider.provider().openSelector();
    protected long bytesRead;

    public ByteBufferInputStream(SocketChannel channel) throws IOException {
        this.channel = channel;
        channel.configureBlocking(false);
        channel.register(this.selector, 1);
        this.buffer = ByteBuffer.allocateDirect(channel.socket().getReceiveBufferSize());
        this.buffer.flip();
    }

    @Override
    public int read() throws IOException {
        if (this.buffer.remaining() < 1) {
            this.read(this.buffer);
        }
        ++this.bytesRead;
        return 0xFF & this.buffer.get();
    }

    private int read(ByteBuffer buffer) throws IOException {
        int n;
        buffer.clear();
        do {
            if ((n = this.channel.read(buffer)) == 0) {
                this.selector.select();
                continue;
            }
            buffer.flip();
        } while (n == 0);
        if (n < 0) {
            throw new CommunicationException("Channel read failed " + n);
        }
        return n;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int rem;
        this.bytesRead += (long)len;
        if (this.buffer.remaining() >= len) {
            this.buffer.get(b, off, len);
            return len;
        }
        int i = off;
        int l = len;
        do {
            if (this.buffer.remaining() == 0) {
                this.read(this.buffer);
            }
            rem = this.buffer.remaining();
            this.buffer.get(b, i, Math.min(rem, l));
            this.buffer.compact();
            this.buffer.flip();
            i += rem;
        } while ((l -= rem) > 0);
        return len;
    }

    @Override
    public void close() throws IOException {
        this.selector.close();
        this.channel.close();
    }

    @Override
    public long getBytesRead() {
        return this.bytesRead;
    }
}

