/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.tarantool.Code;

public class MsgPackLite {
    public static final MsgPackLite INSTANCE = new MsgPackLite();
    protected static final int MAX_4BIT = 15;
    protected static final int MAX_5BIT = 31;
    protected static final int MAX_7BIT = 127;
    protected static final int MAX_8BIT = 255;
    protected static final int MAX_15BIT = Short.MAX_VALUE;
    protected static final int MAX_16BIT = 65535;
    protected static final int MAX_31BIT = Integer.MAX_VALUE;
    protected static final long MAX_32BIT = 0xFFFFFFFFL;
    protected static final BigInteger BI_MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    protected static final BigInteger BI_MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    protected static final BigInteger BI_MAX_64BIT = BigInteger.valueOf(2L).pow(64).subtract(BigInteger.ONE);
    protected static final byte MP_NULL = -64;
    protected static final byte MP_FALSE = -62;
    protected static final byte MP_TRUE = -61;
    protected static final byte MP_BIN8 = -60;
    protected static final byte MP_BIN16 = -59;
    protected static final byte MP_BIN32 = -58;
    protected static final byte MP_FLOAT = -54;
    protected static final byte MP_DOUBLE = -53;
    protected static final byte MP_FIXNUM = 0;
    protected static final byte MP_UINT8 = -52;
    protected static final byte MP_UINT16 = -51;
    protected static final byte MP_UINT32 = -50;
    protected static final byte MP_UINT64 = -49;
    protected static final byte MP_NEGATIVE_FIXNUM = -32;
    protected static final int MP_NEGATIVE_FIXNUM_INT = 224;
    protected static final byte MP_INT8 = -48;
    protected static final byte MP_INT16 = -47;
    protected static final byte MP_INT32 = -46;
    protected static final byte MP_INT64 = -45;
    protected static final byte MP_FIXARRAY = -112;
    protected static final int MP_FIXARRAY_INT = 144;
    protected static final byte MP_ARRAY16 = -36;
    protected static final byte MP_ARRAY32 = -35;
    protected static final byte MP_FIXMAP = -128;
    protected static final int MP_FIXMAP_INT = 128;
    protected static final byte MP_MAP16 = -34;
    protected static final byte MP_MAP32 = -33;
    protected static final byte MP_FIXSTR = -96;
    protected static final int MP_FIXSTR_INT = 160;
    protected static final byte MP_STR8 = -39;
    protected static final byte MP_STR16 = -38;
    protected static final byte MP_STR32 = -37;

    public void pack(Object item, OutputStream os) throws IOException {
        DataOutputStream out = new DataOutputStream(os);
        if (item instanceof Callable) {
            try {
                item = ((Callable)item).call();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (item == null) {
            out.write(-64);
        } else if (item instanceof Boolean) {
            out.write((Boolean)item != false ? -61 : -62);
        } else if (item instanceof Number || item instanceof Code) {
            if (item instanceof Float) {
                out.write(-54);
                out.writeFloat(((Float)item).floatValue());
            } else if (item instanceof Double) {
                out.write(-53);
                out.writeDouble((Double)item);
            } else {
                long value;
                if (item instanceof BigInteger) {
                    boolean isPositive;
                    BigInteger value2 = (BigInteger)item;
                    boolean bl = isPositive = value2.signum() >= 0;
                    if (isPositive && value2.compareTo(BI_MAX_64BIT) > 0 || value2.compareTo(BI_MIN_LONG) < 0) {
                        throw new IllegalArgumentException("Cannot encode BigInteger as MsgPack: out of -2^63..2^64-1 range");
                    }
                    if (isPositive && value2.compareTo(BI_MAX_LONG) > 0) {
                        byte[] data = value2.toByteArray();
                        for (int i = 0; i < data.length - 8; ++i) {
                            assert (data[i] == 0);
                        }
                        out.write(-49);
                        out.write(data, data.length - 8, 8);
                        return;
                    }
                }
                long l = value = item instanceof Code ? (long)((Code)((Object)item)).getId() : ((Number)item).longValue();
                if (value >= 0L) {
                    if (value <= 127L) {
                        out.write((int)value | 0);
                    } else if (value <= 255L) {
                        out.write(-52);
                        out.write((int)value);
                    } else if (value <= 65535L) {
                        out.write(-51);
                        out.writeShort((int)value);
                    } else if (value <= 0xFFFFFFFFL) {
                        out.write(-50);
                        out.writeInt((int)value);
                    } else {
                        out.write(-49);
                        out.writeLong(value);
                    }
                } else if (value >= -32L) {
                    out.write((int)(value & 0xFFL));
                } else if (value >= -128L) {
                    out.write(-48);
                    out.write((int)value);
                } else if (value >= -32768L) {
                    out.write(-47);
                    out.writeShort((int)value);
                } else if (value >= Integer.MIN_VALUE) {
                    out.write(-46);
                    out.writeInt((int)value);
                } else {
                    out.write(-45);
                    out.writeLong(value);
                }
            }
        } else if (item instanceof String) {
            byte[] data = ((String)item).getBytes("UTF-8");
            if (data.length <= 31) {
                out.write(data.length | 0xFFFFFFA0);
            } else if (data.length <= 255) {
                out.write(-39);
                out.writeByte(data.length);
            } else if (data.length <= 65535) {
                out.write(-38);
                out.writeShort(data.length);
            } else {
                out.write(-37);
                out.writeInt(data.length);
            }
            out.write(data);
        } else if (item instanceof byte[] || item instanceof ByteBuffer) {
            byte[] data;
            if (item instanceof byte[]) {
                data = (byte[])item;
            } else {
                ByteBuffer bb = (ByteBuffer)item;
                if (bb.hasArray()) {
                    data = bb.array();
                } else {
                    data = new byte[bb.capacity()];
                    bb.position();
                    bb.limit(bb.capacity());
                    bb.get(data);
                }
            }
            if (data.length <= 255) {
                out.write(-60);
                out.writeByte(data.length);
            } else if (data.length <= 65535) {
                out.write(-59);
                out.writeShort(data.length);
            } else {
                out.write(-58);
                out.writeInt(data.length);
            }
            out.write(data);
        } else if (item instanceof List || item.getClass().isArray()) {
            int length;
            int n = length = item instanceof List ? ((List)item).size() : Array.getLength(item);
            if (length <= 15) {
                out.write(length | 0xFFFFFF90);
            } else if (length <= 65535) {
                out.write(-36);
                out.writeShort(length);
            } else {
                out.write(-35);
                out.writeInt(length);
            }
            if (item instanceof List) {
                List list = (List)item;
                for (Object element : list) {
                    this.pack(element, out);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    this.pack(Array.get(item, i), out);
                }
            }
        } else if (item instanceof Map) {
            Map map = (Map)item;
            if (map.size() <= 15) {
                out.write(map.size() | 0xFFFFFF80);
            } else if (map.size() <= 65535) {
                out.write(-34);
                out.writeShort(map.size());
            } else {
                out.write(-33);
                out.writeInt(map.size());
            }
            for (Map.Entry kvp : map.entrySet()) {
                this.pack(kvp.getKey(), out);
                this.pack(kvp.getValue(), out);
            }
        } else {
            throw new IllegalArgumentException("Cannot msgpack object of type " + item.getClass().getCanonicalName());
        }
    }

    public Object unpack(InputStream is) throws IOException {
        DataInputStream in = new DataInputStream(is);
        int value = in.read();
        if (value < 0) {
            throw new IllegalArgumentException("No more input available when expecting a value");
        }
        switch ((byte)value) {
            case -64: {
                return null;
            }
            case -62: {
                return false;
            }
            case -61: {
                return true;
            }
            case -54: {
                return Float.valueOf(in.readFloat());
            }
            case -53: {
                return in.readDouble();
            }
            case -52: {
                return in.read();
            }
            case -51: {
                return in.readShort() & 0xFFFF;
            }
            case -50: {
                return (long)in.readInt() & 0xFFFFFFFFL;
            }
            case -49: {
                long v = in.readLong();
                if (v >= 0L) {
                    return v;
                }
                byte[] bytes = new byte[]{(byte)(v >> 56 & 0xFFL), (byte)(v >> 48 & 0xFFL), (byte)(v >> 40 & 0xFFL), (byte)(v >> 32 & 0xFFL), (byte)(v >> 24 & 0xFFL), (byte)(v >> 16 & 0xFFL), (byte)(v >> 8 & 0xFFL), (byte)(v & 0xFFL)};
                return new BigInteger(1, bytes);
            }
            case -48: {
                return (byte)in.read();
            }
            case -47: {
                return in.readShort();
            }
            case -46: {
                return in.readInt();
            }
            case -45: {
                return in.readLong();
            }
            case -36: {
                return this.unpackList(in.readShort() & 0xFFFF, in);
            }
            case -35: {
                return this.unpackList(in.readInt(), in);
            }
            case -34: {
                return this.unpackMap(in.readShort() & 0xFFFF, in);
            }
            case -33: {
                return this.unpackMap(in.readInt(), in);
            }
            case -39: {
                return this.unpackStr(in.readByte() & 0xFF, in);
            }
            case -38: {
                return this.unpackStr(in.readShort() & 0xFFFF, in);
            }
            case -37: {
                return this.unpackStr(in.readInt(), in);
            }
            case -60: {
                return this.unpackBin(in.readByte() & 0xFF, in);
            }
            case -59: {
                return this.unpackBin(in.readShort() & 0xFFFF, in);
            }
            case -58: {
                return this.unpackBin(in.readInt(), in);
            }
        }
        if (value >= 224 && value <= 255) {
            return (byte)value;
        }
        if (value >= 144 && value <= 159) {
            return this.unpackList(value - 144, in);
        }
        if (value >= 128 && value <= 143) {
            return this.unpackMap(value - 128, in);
        }
        if (value >= 160 && value <= 191) {
            return this.unpackStr(value - 160, in);
        }
        if (value <= 127) {
            return value;
        }
        throw new IllegalArgumentException("Input contains invalid type value " + (byte)value);
    }

    protected List unpackList(int size, DataInputStream in) throws IOException {
        if (size < 0) {
            throw new IllegalArgumentException("Array to unpack too large for Java (more than 2^31 elements)!");
        }
        ArrayList<Object> ret = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            ret.add(this.unpack(in));
        }
        return ret;
    }

    protected Map unpackMap(int size, DataInputStream in) throws IOException {
        if (size < 0) {
            throw new IllegalArgumentException("Map to unpack too large for Java (more than 2^31 elements)!");
        }
        HashMap<Object, Object> ret = new HashMap<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            Object key = this.unpack(in);
            Object value = this.unpack(in);
            ret.put(key, value);
        }
        return ret;
    }

    protected Object unpackStr(int size, DataInputStream in) throws IOException {
        if (size < 0) {
            throw new IllegalArgumentException("byte[] to unpack too large for Java (more than 2^31 elements)!");
        }
        byte[] data = new byte[size];
        in.readFully(data);
        return new String(data, "UTF-8");
    }

    protected Object unpackBin(int size, DataInputStream in) throws IOException {
        if (size < 0) {
            throw new IllegalArgumentException("byte[] to unpack too large for Java (more than 2^31 elements)!");
        }
        byte[] data = new byte[size];
        in.readFully(data);
        return data;
    }
}

