/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.tarantool.BaseSocketChannelProvider;
import org.tarantool.CommunicationException;
import org.tarantool.RefreshableSocketProvider;

public class RoundRobinSocketProviderImpl
extends BaseSocketChannelProvider
implements RefreshableSocketProvider {
    private static final int UNSET_POSITION = -1;
    private static final int DEFAULT_RETRIES_PER_CONNECTION = 3;
    private final List<InetSocketAddress> socketAddresses = new ArrayList<InetSocketAddress>();
    private AtomicInteger currentPosition = new AtomicInteger(-1);
    private ReadWriteLock addressListLock = new ReentrantReadWriteLock();

    public RoundRobinSocketProviderImpl(String ... addresses) {
        this.updateAddressList(Arrays.asList(addresses));
        this.setRetriesLimit(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAddressList(Collection<String> addresses) {
        if (addresses == null || addresses.isEmpty()) {
            throw new IllegalArgumentException("At least one address must be provided");
        }
        Lock writeLock = this.addressListLock.writeLock();
        writeLock.lock();
        try {
            InetSocketAddress lastAddress = this.getLastObtainedAddress();
            this.socketAddresses.clear();
            addresses.stream().map(this::parseAddress).collect(Collectors.toCollection(() -> this.socketAddresses));
            if (lastAddress != null) {
                int recoveredPosition = this.socketAddresses.indexOf(lastAddress);
                this.currentPosition.set(recoveredPosition);
            } else {
                this.currentPosition.set(-1);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public List<SocketAddress> getAddresses() {
        return this.readGuard(() -> Collections.unmodifiableList(this.socketAddresses));
    }

    protected InetSocketAddress getLastObtainedAddress() {
        return this.readGuard(() -> {
            int index = this.currentPosition.get();
            return index != -1 ? this.socketAddresses.get(index) : null;
        });
    }

    @Override
    protected SocketChannel makeAttempt(int retryNumber, Throwable lastError) throws IOException {
        if (retryNumber > this.getAddressCount()) {
            this.throwFatalError("No more connection addresses are left.", lastError);
        }
        int retriesLimit = this.getRetriesLimit();
        InetSocketAddress socketAddress = this.getNextSocketAddress();
        IOException connectionError = null;
        for (int i = 0; i < retriesLimit; ++i) {
            try {
                return this.openChannel(socketAddress);
            }
            catch (IOException e) {
                connectionError = e;
                continue;
            }
        }
        throw connectionError;
    }

    @Override
    public void setRetriesLimit(int retriesLimit) {
        if (retriesLimit == 0) {
            this.throwFatalError("Retries count should be at least 1 or more", null);
        }
        super.setRetriesLimit(retriesLimit);
    }

    protected int getAddressCount() {
        return this.readGuard(this.socketAddresses::size);
    }

    protected InetSocketAddress getNextSocketAddress() {
        return this.readGuard(() -> {
            int position = this.currentPosition.updateAndGet(i -> (i + 1) % this.socketAddresses.size());
            return this.socketAddresses.get(position);
        });
    }

    @Override
    public SocketAddress getAddress() {
        return this.readGuard(() -> {
            int position = (this.currentPosition.get() + 1) % this.socketAddresses.size();
            return this.socketAddresses.get(position);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R readGuard(Supplier<R> supplier) {
        Lock readLock = this.addressListLock.readLock();
        readLock.lock();
        try {
            R r = supplier.get();
            return r;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public void refreshAddresses(Collection<String> addresses) {
        this.updateAddressList(addresses);
    }

    private void throwFatalError(String message, Throwable lastError) {
        throw new CommunicationException(message, lastError);
    }
}

