/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import org.tarantool.BaseSocketChannelProvider;
import org.tarantool.CommunicationException;
import org.tarantool.util.StringUtils;

public class SingleSocketChannelProviderImpl
extends BaseSocketChannelProvider {
    private InetSocketAddress address;

    public SingleSocketChannelProviderImpl(String address) {
        this.setAddress(address);
    }

    @Override
    public SocketAddress getAddress() {
        return this.address;
    }

    @Override
    protected SocketChannel makeAttempt(int retryNumber, Throwable lastError) throws IOException {
        if (this.areRetriesExhausted(retryNumber)) {
            throw new CommunicationException("Connection retries exceeded.", lastError);
        }
        return this.openChannel(this.address);
    }

    private boolean areRetriesExhausted(int retryNumber) {
        int limit = this.getRetriesLimit();
        if (limit < 1) {
            return false;
        }
        return retryNumber >= limit;
    }

    public void setAddress(String address) {
        if (StringUtils.isBlank(address)) {
            throw new IllegalArgumentException("address must not be empty");
        }
        this.address = this.parseAddress(address);
    }
}

