/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.tarantool.Key;
import org.tarantool.jdbc.type.TarantoolSqlType;
import org.tarantool.jdbc.type.TarantoolType;
import org.tarantool.protocol.TarantoolPacket;

public abstract class SqlProtoUtils {
    public static List<Map<String, Object>> readSqlResult(TarantoolPacket pack) {
        List<List<Object>> data = SqlProtoUtils.getSQLData(pack);
        List<SQLMetaData> metaData = SqlProtoUtils.getSQLMetadata(pack);
        ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>(data.size());
        for (List<Object> row : data) {
            LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>();
            for (int i = 0; i < row.size(); ++i) {
                value.put(metaData.get(i).getName(), row.get(i));
            }
            values.add(value);
        }
        return values;
    }

    public static List<List<Object>> getSQLData(TarantoolPacket pack) {
        return (List)pack.getBody().get(Key.DATA.getId());
    }

    public static List<SQLMetaData> getSQLMetadata(TarantoolPacket pack) {
        List meta = (List)pack.getBody().get(Key.SQL_METADATA.getId());
        ArrayList<SQLMetaData> values = new ArrayList<SQLMetaData>(meta.size());
        for (Map item : meta) {
            values.add(new SQLMetaData((String)item.get(Key.SQL_FIELD_NAME.getId()), (String)item.get(Key.SQL_FIELD_TYPE.getId())));
        }
        return values;
    }

    public static Long getSQLRowCount(TarantoolPacket pack) {
        Number rowCount;
        Map info = (Map)pack.getBody().get(Key.SQL_INFO.getId());
        if (info != null && (rowCount = (Number)info.get(Key.SQL_ROW_COUNT.getId())) != null) {
            return rowCount.longValue();
        }
        return null;
    }

    public static List<Integer> getSQLAutoIncrementIds(TarantoolPacket pack) {
        Map info = (Map)pack.getBody().get(Key.SQL_INFO.getId());
        if (info != null) {
            List generatedIds = (List)info.get(Key.SQL_INFO_AUTOINCREMENT_IDS.getId());
            return generatedIds == null ? Collections.emptyList() : generatedIds;
        }
        return Collections.emptyList();
    }

    public static class SQLMetaData {
        private String name;
        private TarantoolSqlType type;

        public SQLMetaData(String name, String tarantoolType) {
            this(name, TarantoolSqlType.getDefaultSqlType(TarantoolType.of(tarantoolType)));
        }

        public SQLMetaData(String name, TarantoolSqlType type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public TarantoolSqlType getType() {
            return this.type;
        }

        public String toString() {
            return "SQLMetaData{name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + '}';
        }
    }
}

