/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool;

import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicLong;
import org.tarantool.AbstractTarantoolOps;
import org.tarantool.CommunicationException;
import org.tarantool.MsgPackLite;
import org.tarantool.TarantoolException;
import org.tarantool.protocol.ProtoUtils;
import org.tarantool.protocol.TarantoolGreeting;

public abstract class TarantoolBase<Result>
extends AbstractTarantoolOps<Result> {
    protected String serverVersion;
    protected MsgPackLite msgPackLite = MsgPackLite.INSTANCE;
    protected AtomicLong syncId = new AtomicLong();
    protected int initialRequestSize = 4096;

    public TarantoolBase() {
    }

    public TarantoolBase(String username, String password, Socket socket) {
        try {
            TarantoolGreeting greeting = ProtoUtils.connect(socket, username, password, this.msgPackLite);
            this.serverVersion = greeting.getServerVersion();
        }
        catch (IOException e) {
            throw new CommunicationException("Couldn't connect to tarantool", e);
        }
    }

    protected TarantoolException serverError(long code, Object error) {
        return new TarantoolException(code, error instanceof String ? (String)error : new String((byte[])error));
    }

    protected void closeChannel(SocketChannel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setInitialRequestSize(int initialRequestSize) {
        this.initialRequestSize = initialRequestSize;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }
}

