/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.StampedLock;
import org.tarantool.AbstractTarantoolOps;
import org.tarantool.Code;
import org.tarantool.CommunicationException;
import org.tarantool.ConfigurableSocketChannelProvider;
import org.tarantool.Key;
import org.tarantool.SingleSocketChannelProviderImpl;
import org.tarantool.SocketChannelProvider;
import org.tarantool.SocketProviderTransientException;
import org.tarantool.SqlProtoUtils;
import org.tarantool.TarantoolBase;
import org.tarantool.TarantoolClient;
import org.tarantool.TarantoolClientConfig;
import org.tarantool.TarantoolClientOps;
import org.tarantool.TarantoolClientStats;
import org.tarantool.TarantoolException;
import org.tarantool.TarantoolOperation;
import org.tarantool.TarantoolRequest;
import org.tarantool.TarantoolRequestArgumentFactory;
import org.tarantool.TarantoolSQLOps;
import org.tarantool.TarantoolThreadDaemonFactory;
import org.tarantool.logging.Logger;
import org.tarantool.logging.LoggerFactory;
import org.tarantool.protocol.ProtoUtils;
import org.tarantool.protocol.ReadableViaSelectorChannel;
import org.tarantool.protocol.TarantoolGreeting;
import org.tarantool.protocol.TarantoolPacket;
import org.tarantool.schema.TarantoolMetaSpacesCache;
import org.tarantool.schema.TarantoolSchemaException;
import org.tarantool.schema.TarantoolSchemaMeta;
import org.tarantool.util.StringUtils;
import org.tarantool.util.TupleTwo;

public class TarantoolClientImpl
extends TarantoolBase<Future<?>>
implements TarantoolClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TarantoolClientImpl.class);
    protected TarantoolClientConfig config;
    protected Duration operationTimeout;
    protected SocketChannelProvider socketProvider;
    protected SocketChannel channel;
    protected ReadableViaSelectorChannel readChannel;
    protected volatile Exception thumbstone;
    protected ScheduledExecutorService workExecutor;
    protected StampedLock schemaLock = new StampedLock();
    protected BlockingQueue<TarantoolOperation> delayedOperationsQueue;
    protected Map<Long, TarantoolOperation> futures;
    protected AtomicInteger pendingResponsesCount = new AtomicInteger();
    protected ByteBuffer sharedBuffer;
    protected ReentrantLock bufferLock = new ReentrantLock(false);
    protected Condition bufferNotEmpty = this.bufferLock.newCondition();
    protected Condition bufferEmpty = this.bufferLock.newCondition();
    protected ByteBuffer writerBuffer;
    protected ReentrantLock writeLock = new ReentrantLock(true);
    protected SyncOps syncOps;
    protected FireAndForgetOps fireAndForgetOps;
    protected ComposableAsyncOps composableAsyncOps;
    protected UnsafeSchemaOps unsafeSchemaOps;
    protected TarantoolClientStats stats;
    protected StateHelper state = new StateHelper(8);
    protected Thread reader;
    protected Thread writer;
    protected TarantoolSchemaMeta schemaMeta = new TarantoolMetaSpacesCache(this);
    protected Thread connector = new Thread(new Runnable(){

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                TarantoolClientImpl.this.reconnect(TarantoolClientImpl.this.thumbstone);
                try {
                    TarantoolClientImpl.this.state.awaitReconnection();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    });

    public TarantoolClientImpl(String address, TarantoolClientConfig config) {
        this(new SingleSocketChannelProviderImpl(address), config);
    }

    public TarantoolClientImpl(SocketChannelProvider socketProvider, TarantoolClientConfig config) {
        this.initClient(socketProvider, config);
        if (socketProvider instanceof ConfigurableSocketChannelProvider) {
            ConfigurableSocketChannelProvider configurableProvider = (ConfigurableSocketChannelProvider)socketProvider;
            configurableProvider.setConnectionTimeout(config.connectionTimeout);
            configurableProvider.setRetriesLimit(config.retryCount);
        }
        this.startConnector(config.initTimeoutMillis);
    }

    private void initClient(SocketChannelProvider socketProvider, TarantoolClientConfig config) {
        this.config = config;
        this.initialRequestSize = config.defaultRequestSize;
        this.operationTimeout = Duration.ofMillis(config.operationExpiryTimeMillis);
        this.socketProvider = socketProvider;
        this.stats = new TarantoolClientStats();
        this.futures = new ConcurrentHashMap<Long, TarantoolOperation>(config.predictedFutures);
        this.delayedOperationsQueue = new PriorityBlockingQueue<TarantoolOperation>(128);
        this.workExecutor = Executors.newSingleThreadScheduledExecutor(new TarantoolThreadDaemonFactory("tarantool-worker"));
        this.sharedBuffer = ByteBuffer.allocateDirect(config.sharedBufferSize);
        this.writerBuffer = ByteBuffer.allocateDirect(this.sharedBuffer.capacity());
        this.connector.setDaemon(true);
        this.connector.setName("Tarantool connector");
        this.syncOps = new SyncOps();
        this.composableAsyncOps = new ComposableAsyncOps();
        this.fireAndForgetOps = new FireAndForgetOps();
        this.unsafeSchemaOps = new UnsafeSchemaOps();
        if (!config.useNewCall) {
            this.setCallCode(Code.OLD_CALL);
            this.syncOps.setCallCode(Code.OLD_CALL);
            this.fireAndForgetOps.setCallCode(Code.OLD_CALL);
            this.composableAsyncOps.setCallCode(Code.OLD_CALL);
        }
    }

    private void startConnector(long initTimeoutMillis) {
        this.connector.start();
        try {
            if (!this.waitAlive(initTimeoutMillis, TimeUnit.MILLISECONDS)) {
                CommunicationException e = new CommunicationException(initTimeoutMillis + "ms is exceeded when waiting for client initialization. You could configure init timeout in TarantoolConfig", this.thumbstone);
                this.close(e);
                throw e;
            }
        }
        catch (InterruptedException e) {
            this.close(e);
            throw new IllegalStateException(e);
        }
    }

    protected void reconnect(Throwable lastError) {
        SocketChannel channel = null;
        int retryNumber = 0;
        while (!Thread.currentThread().isInterrupted()) {
            block6: {
                try {
                    if (lastError != null) {
                        LOGGER.warn(() -> {
                            SocketAddress address = this.socketProvider.getAddress();
                            return "Attempt to (re-)connect to Tarantool instance " + (StringUtils.isBlank(this.config.username) ? "" : this.config.username + ":*****@") + (address == null ? "unknown" : address);
                        }, lastError);
                    }
                    channel = this.socketProvider.get(retryNumber++, lastError);
                }
                catch (Exception e) {
                    this.closeChannel(channel);
                    lastError = e;
                    if (e instanceof SocketProviderTransientException) break block6;
                    this.close(e);
                    return;
                }
            }
            try {
                if (channel == null) continue;
                this.connect(channel);
                return;
            }
            catch (Exception e) {
                this.closeChannel(channel);
                lastError = e;
                if (!(e instanceof InterruptedException)) continue;
                Thread.currentThread().interrupt();
            }
        }
    }

    protected void connect(SocketChannel channel) throws Exception {
        try {
            TarantoolGreeting greeting = ProtoUtils.connect(channel, this.config.username, this.config.password, this.msgPackLite);
            this.serverVersion = greeting.getServerVersion();
        }
        catch (IOException e) {
            this.closeChannel(channel);
            throw new CommunicationException("Couldn't connect to tarantool", e);
        }
        channel.configureBlocking(false);
        this.channel = channel;
        this.readChannel = new ReadableViaSelectorChannel(channel);
        this.bufferLock.lock();
        try {
            this.sharedBuffer.clear();
        }
        finally {
            this.bufferLock.unlock();
        }
        this.thumbstone = null;
        this.startThreads(channel.socket().getRemoteSocketAddress().toString());
        this.updateSchema();
    }

    protected void startThreads(String threadName) throws InterruptedException {
        CountDownLatch ioThreadStarted = new CountDownLatch(2);
        AtomicInteger leftIoThreads = new AtomicInteger(2);
        this.reader = new Thread(() -> {
            ioThreadStarted.countDown();
            if (this.state.acquire(1)) {
                try {
                    this.readThread();
                }
                finally {
                    this.state.release(5);
                    if (leftIoThreads.decrementAndGet() == 0) {
                        this.state.trySignalForReconnection();
                    }
                }
            }
        });
        this.writer = new Thread(() -> {
            ioThreadStarted.countDown();
            if (this.state.acquire(2)) {
                try {
                    this.writeThread();
                }
                finally {
                    this.state.release(6);
                    if (leftIoThreads.decrementAndGet() == 0) {
                        this.state.trySignalForReconnection();
                    }
                }
            }
        });
        this.state.release(8);
        this.configureThreads(threadName);
        this.reader.start();
        this.writer.start();
        ioThreadStarted.await();
    }

    protected void configureThreads(String threadName) {
        this.reader.setName("Tarantool " + threadName + " reader");
        this.writer.setName("Tarantool " + threadName + " writer");
        this.writer.setPriority(this.config.writerThreadPriority);
        this.reader.setPriority(this.config.readerThreadPriority);
    }

    @Override
    public TarantoolSchemaMeta getSchemaMeta() {
        return this.schemaMeta;
    }

    @Override
    protected Future<?> exec(TarantoolRequest request) {
        return this.doExec(request).getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TarantoolOperation doExec(TarantoolRequest request) {
        long stamp = this.schemaLock.readLock();
        try {
            TarantoolOperation operation;
            if (request.getTimeout() == null) {
                request.setTimeout(this.operationTimeout);
            }
            if (!(operation = request.toOperation(this.syncId.incrementAndGet(), this.schemaMeta.getSchemaVersion())).isSerializable()) {
                this.delayedOperationsQueue.add(operation);
                if (this.isSchemaLoaded()) {
                    TarantoolOperation ping = new TarantoolRequest(Code.PING).toPreflightOperation(this.syncId.incrementAndGet(), this.schemaMeta.getSchemaVersion(), operation);
                    this.registerOperation(ping);
                }
                TarantoolOperation tarantoolOperation = operation;
                return tarantoolOperation;
            }
            if (!this.isSchemaLoaded()) {
                this.delayedOperationsQueue.add(operation);
                TarantoolOperation tarantoolOperation = operation;
                return tarantoolOperation;
            }
            TarantoolOperation tarantoolOperation = this.registerOperation(operation);
            return tarantoolOperation;
        }
        finally {
            this.schemaLock.unlockRead(stamp);
        }
    }

    private boolean isSchemaLoaded() {
        return this.schemaMeta.isInitialized() && !this.state.isStateSet(4);
    }

    protected TarantoolOperation registerOperation(TarantoolOperation operation) {
        if (this.isDead(operation)) {
            return operation;
        }
        this.futures.put(operation.getId(), operation);
        if (this.isDead(operation)) {
            this.futures.remove(operation.getId());
            return operation;
        }
        try {
            this.write(operation.getCode(), operation.getId(), operation.getSentSchemaId(), operation.getArguments().toArray());
        }
        catch (Exception e) {
            this.futures.remove(operation.getId());
            this.fail(operation, e);
        }
        return operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void die(String message, Exception cause) {
        TarantoolOperation operation;
        if (this.thumbstone != null) {
            return;
        }
        CommunicationException error = new CommunicationException(message, cause);
        this.thumbstone = error;
        while (!this.futures.isEmpty()) {
            Iterator<Map.Entry<Long, TarantoolOperation>> iterator = this.futures.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, TarantoolOperation> elem = iterator.next();
                if (elem != null) {
                    TarantoolOperation operation2 = elem.getValue();
                    this.fail(operation2, error);
                }
                iterator.remove();
            }
        }
        while ((operation = (TarantoolOperation)this.delayedOperationsQueue.poll()) != null) {
            this.fail(operation, error);
        }
        this.pendingResponsesCount.set(0);
        this.bufferLock.lock();
        try {
            this.sharedBuffer.clear();
            this.bufferEmpty.signalAll();
        }
        finally {
            this.bufferLock.unlock();
        }
        this.stopIO();
    }

    @Override
    public void ping() {
        this.syncGet((Future)this.exec(new TarantoolRequest(Code.PING)));
    }

    protected void write(Code code, Long syncId, Long schemaId, Object ... args) throws Exception {
        ByteBuffer buffer = ProtoUtils.createPacket(this.msgPackLite, code, syncId, schemaId, args);
        if (this.directWrite(buffer)) {
            return;
        }
        this.sharedWrite(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sharedWrite(ByteBuffer buffer) throws InterruptedException, TimeoutException {
        long start = System.currentTimeMillis();
        if (this.bufferLock.tryLock(this.config.writeTimeoutMillis, TimeUnit.MILLISECONDS)) {
            try {
                int rem = buffer.remaining();
                this.stats.sharedMaxPacketSize = Math.max(this.stats.sharedMaxPacketSize, (long)rem);
                if (rem > this.initialRequestSize) {
                    ++this.stats.sharedPacketSizeGrowth;
                }
                while (this.sharedBuffer.remaining() < buffer.limit()) {
                    ++this.stats.sharedEmptyAwait;
                    long remaining = this.config.writeTimeoutMillis - (System.currentTimeMillis() - start);
                    try {
                        if (remaining >= 1L && this.bufferEmpty.await(remaining, TimeUnit.MILLISECONDS)) continue;
                        ++this.stats.sharedEmptyAwaitTimeouts;
                        throw new TimeoutException(this.config.writeTimeoutMillis + "ms is exceeded while waiting for empty buffer. You could configure write timeout it in TarantoolConfig");
                    }
                    catch (InterruptedException e) {
                        throw new CommunicationException("Interrupted", e);
                    }
                }
                this.sharedBuffer.put(buffer);
                this.pendingResponsesCount.incrementAndGet();
                this.bufferNotEmpty.signalAll();
                ++this.stats.buffered;
            }
            finally {
                this.bufferLock.unlock();
            }
        } else {
            ++this.stats.sharedWriteLockTimeouts;
            throw new TimeoutException(this.config.writeTimeoutMillis + "ms is exceeded while waiting for shared buffer lock. You could configure write timeout in TarantoolConfig");
        }
    }

    private boolean directWrite(ByteBuffer buffer) throws InterruptedException, IOException, TimeoutException {
        if ((double)this.sharedBuffer.capacity() * this.config.directWriteFactor <= (double)buffer.limit()) {
            if (this.writeLock.tryLock(this.config.writeTimeoutMillis, TimeUnit.MILLISECONDS)) {
                try {
                    int rem = buffer.remaining();
                    this.stats.directMaxPacketSize = Math.max(this.stats.directMaxPacketSize, (long)rem);
                    if (rem > this.initialRequestSize) {
                        ++this.stats.directPacketSizeGrowth;
                    }
                    this.writeFully(this.channel, buffer);
                    ++this.stats.directWrite;
                    this.pendingResponsesCount.incrementAndGet();
                }
                finally {
                    this.writeLock.unlock();
                }
                return true;
            }
            ++this.stats.directWriteLockTimeouts;
            throw new TimeoutException(this.config.writeTimeoutMillis + "ms is exceeded while waiting for channel lock. You could configure write timeout in TarantoolConfig");
        }
        return false;
    }

    protected void readThread() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                TarantoolPacket packet = ProtoUtils.readPacket(this.readChannel, this.msgPackLite);
                Map<Integer, Object> headers = packet.getHeaders();
                Long syncId = (Long)headers.get(Key.SYNC.getId());
                TarantoolOperation request = this.futures.remove(syncId);
                ++this.stats.received;
                this.pendingResponsesCount.decrementAndGet();
                this.complete(packet, request);
            }
            catch (Exception e) {
                this.die("Cant read answer", e);
                return;
            }
        }
    }

    protected void writeThread() {
        this.writerBuffer.clear();
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.bufferLock.lock();
                try {
                    while (this.sharedBuffer.position() == 0) {
                        this.bufferNotEmpty.await();
                    }
                    this.sharedBuffer.flip();
                    this.writerBuffer.put(this.sharedBuffer);
                    this.sharedBuffer.clear();
                    this.bufferEmpty.signalAll();
                }
                finally {
                    this.bufferLock.unlock();
                }
                this.writerBuffer.flip();
                this.writeLock.lock();
                try {
                    this.writeFully(this.channel, this.writerBuffer);
                }
                finally {
                    this.writeLock.unlock();
                }
                this.writerBuffer.clear();
                ++this.stats.sharedWrites;
            }
            catch (Exception e) {
                this.die("Cant write bytes", e);
                return;
            }
        }
    }

    protected void fail(TarantoolOperation operation, Exception e) {
        operation.getResult().completeExceptionally(e);
    }

    protected void complete(TarantoolPacket packet, TarantoolOperation operation) {
        boolean isPreflightPing;
        CompletableFuture<?> result = operation.getResult();
        if (result.isDone()) {
            return;
        }
        long code = packet.getCode();
        long schemaId = packet.getSchemaId();
        boolean bl = isPreflightPing = operation.getDependedOperation() != null;
        if (code == 0L) {
            operation.setCompletedSchemaId(schemaId);
            if (isPreflightPing) {
                TarantoolOperation target = operation.getDependedOperation();
                this.delayedOperationsQueue.remove(target);
                try {
                    target.getArguments();
                }
                catch (TarantoolSchemaException cause) {
                    this.fail(target, cause);
                }
            } else if (operation.getCode() == Code.EXECUTE) {
                this.completeSql(operation, packet);
            } else {
                result.complete(packet.getData());
            }
        } else if (code == 109L) {
            if (schemaId > this.schemaMeta.getSchemaVersion()) {
                this.delayedOperationsQueue.add(operation);
            } else {
                operation.setSentSchemaId(this.schemaMeta.getSchemaVersion());
                this.registerOperation(operation);
            }
        } else {
            Object error = packet.getError();
            this.fail(operation, this.serverError(code, error));
        }
        if (operation.getSentSchemaId() == 0L) {
            return;
        }
        if (schemaId > this.schemaMeta.getSchemaVersion()) {
            this.updateSchema();
        }
    }

    private void updateSchema() {
        this.performSchemaAction(() -> {
            if (this.state.acquire(4)) {
                this.workExecutor.execute(this.createUpdateSchemaTask());
            }
        });
    }

    private Runnable createUpdateSchemaTask() {
        return () -> {
            try {
                this.schemaMeta.refresh();
            }
            catch (Exception cause) {
                this.workExecutor.schedule(this.createUpdateSchemaTask(), 300L, TimeUnit.MILLISECONDS);
                return;
            }
            this.performSchemaAction(() -> {
                try {
                    this.rescheduleDelayedOperations();
                }
                finally {
                    this.state.release(4);
                }
            });
        };
    }

    private void rescheduleDelayedOperations() {
        TarantoolOperation operation;
        while ((operation = (TarantoolOperation)this.delayedOperationsQueue.poll()) != null) {
            CompletableFuture<?> result = operation.getResult();
            if (result.isDone()) continue;
            operation.setSentSchemaId(this.schemaMeta.getSchemaVersion());
            this.registerOperation(operation);
        }
    }

    protected void completeSql(TarantoolOperation operation, TarantoolPacket pack) {
        Long rowCount = SqlProtoUtils.getSQLRowCount(pack);
        CompletableFuture<?> result = operation.getResult();
        if (rowCount != null) {
            result.complete(rowCount);
        } else {
            List<Map<String, Object>> values = SqlProtoUtils.readSqlResult(pack);
            result.complete(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performSchemaAction(Runnable action) {
        long stamp = this.schemaLock.writeLock();
        try {
            action.run();
        }
        finally {
            this.schemaLock.unlockWrite(stamp);
        }
    }

    protected <T> T syncGet(Future<T> result) {
        try {
            return result.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CommunicationException) {
                throw (CommunicationException)e.getCause();
            }
            if (e.getCause() instanceof TarantoolException) {
                throw (TarantoolException)e.getCause();
            }
            throw new IllegalStateException(e.getCause());
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void writeFully(SocketChannel channel, ByteBuffer buffer) throws IOException {
        ProtoUtils.writeFully(channel, buffer);
    }

    @Override
    public void close() {
        this.close(new Exception("Connection is closed."));
        try {
            this.state.awaitState(16);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    protected void close(Exception e) {
        if (this.state.close()) {
            if (this.workExecutor != null) {
                this.workExecutor.shutdownNow();
            }
            this.connector.interrupt();
            this.die(e.getMessage(), e);
        }
    }

    protected void stopIO() {
        if (this.reader != null) {
            this.reader.interrupt();
        }
        if (this.writer != null) {
            this.writer.interrupt();
        }
        if (this.readChannel != null) {
            try {
                this.readChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.closeChannel(this.channel);
    }

    public long getOperationTimeout() {
        return this.operationTimeout.toMillis();
    }

    public void setOperationTimeout(long operationTimeout) {
        this.operationTimeout = Duration.ofMillis(operationTimeout);
    }

    @Override
    public boolean isAlive() {
        return this.state.isStateSet(3) && this.thumbstone == null;
    }

    @Override
    public boolean isClosed() {
        return this.state.isStateSet(16);
    }

    @Override
    public void waitAlive() throws InterruptedException {
        this.state.awaitState(3);
    }

    @Override
    public boolean waitAlive(long timeout, TimeUnit unit) throws InterruptedException {
        return this.state.awaitState(3, timeout, unit);
    }

    @Override
    public TarantoolClientOps<Integer, List<?>, Object, List<?>> syncOps() {
        return this.syncOps;
    }

    @Override
    public TarantoolClientOps<Integer, List<?>, Object, Future<List<?>>> asyncOps() {
        return this;
    }

    @Override
    public TarantoolClientOps<Integer, List<?>, Object, CompletionStage<List<?>>> composableAsyncOps() {
        return this.composableAsyncOps;
    }

    @Override
    public TarantoolClientOps<Integer, List<?>, Object, Long> fireAndForgetOps() {
        return this.fireAndForgetOps;
    }

    public TarantoolClientOps<Integer, List<?>, Object, TupleTwo<List<?>, Long>> unsafeSchemaOps() {
        return this.unsafeSchemaOps;
    }

    protected TarantoolRequest makeSqlRequest(String sql, List<Object> bind) {
        return new TarantoolRequest(Code.EXECUTE, TarantoolRequestArgumentFactory.value(Key.SQL_TEXT), TarantoolRequestArgumentFactory.value(sql), TarantoolRequestArgumentFactory.value(Key.SQL_BIND), TarantoolRequestArgumentFactory.value(bind));
    }

    @Override
    public TarantoolSQLOps<Object, Long, List<Map<String, Object>>> sqlSyncOps() {
        return new TarantoolSQLOps<Object, Long, List<Map<String, Object>>>(){

            @Override
            public Long update(String sql, Object ... bind) {
                return (Long)TarantoolClientImpl.this.syncGet(TarantoolClientImpl.this.exec(TarantoolClientImpl.this.makeSqlRequest(sql, Arrays.asList(bind))));
            }

            @Override
            public List<Map<String, Object>> query(String sql, Object ... bind) {
                return (List)TarantoolClientImpl.this.syncGet(TarantoolClientImpl.this.exec(TarantoolClientImpl.this.makeSqlRequest(sql, Arrays.asList(bind))));
            }
        };
    }

    @Override
    public TarantoolSQLOps<Object, Future<Long>, Future<List<Map<String, Object>>>> sqlAsyncOps() {
        return new TarantoolSQLOps<Object, Future<Long>, Future<List<Map<String, Object>>>>(){

            @Override
            public Future<Long> update(String sql, Object ... bind) {
                return TarantoolClientImpl.this.exec(TarantoolClientImpl.this.makeSqlRequest(sql, Arrays.asList(bind)));
            }

            @Override
            public Future<List<Map<String, Object>>> query(String sql, Object ... bind) {
                return TarantoolClientImpl.this.exec(TarantoolClientImpl.this.makeSqlRequest(sql, Arrays.asList(bind)));
            }
        };
    }

    protected boolean isDead(TarantoolOperation operation) {
        if (this.thumbstone != null) {
            this.fail(operation, new CommunicationException("Connection is dead", this.thumbstone));
            return true;
        }
        return false;
    }

    protected void onReconnect() {
    }

    public Exception getThumbstone() {
        return this.thumbstone;
    }

    public TarantoolClientStats getStats() {
        return this.stats;
    }

    protected abstract class BaseClientOps<R>
    extends AbstractTarantoolOps<R> {
        protected BaseClientOps() {
        }

        @Override
        protected TarantoolSchemaMeta getSchemaMeta() {
            return TarantoolClientImpl.this.getSchemaMeta();
        }

        @Override
        public void close() {
            throw new IllegalStateException("You should close TarantoolClient instead.");
        }
    }

    protected class UnsafeSchemaOps
    extends BaseClientOps<TupleTwo<List<?>, Long>> {
        protected UnsafeSchemaOps() {
        }

        @Override
        protected TupleTwo<List<?>, Long> exec(TarantoolRequest request) {
            long syncId = TarantoolClientImpl.this.syncId.incrementAndGet();
            TarantoolOperation operation = request.toOperation(syncId, 0L);
            List result = (List)TarantoolClientImpl.this.syncGet(TarantoolClientImpl.this.registerOperation(operation).getResult());
            return TupleTwo.of(result, operation.getCompletedSchemaId());
        }
    }

    protected class ComposableAsyncOps
    extends BaseClientOps<CompletionStage<List<?>>> {
        protected ComposableAsyncOps() {
        }

        @Override
        protected CompletionStage<List<?>> exec(TarantoolRequest request) {
            return (CompletionStage)TarantoolClientImpl.this.exec(request);
        }

        @Override
        public void close() {
            TarantoolClientImpl.this.close();
        }
    }

    protected final class StateHelper {
        static final int UNINITIALIZED = 0;
        static final int READING = 1;
        static final int WRITING = 2;
        static final int ALIVE = 3;
        static final int SCHEMA_UPDATING = 4;
        static final int RECONNECT = 8;
        static final int CLOSED = 16;
        private final AtomicInteger state;
        private final AtomicReference<CountDownLatch> nextAliveLatch = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
        private final CountDownLatch closedLatch = new CountDownLatch(1);
        protected final ReentrantLock connectorLock = new ReentrantLock();
        protected final Condition reconnectRequired = this.connectorLock.newCondition();

        protected StateHelper(int state) {
            this.state = new AtomicInteger(state);
        }

        protected int getState() {
            return this.state.get();
        }

        boolean isStateSet(int mask) {
            return (this.getState() & mask) == mask;
        }

        protected boolean close() {
            int currentState;
            do {
                currentState = this.getState();
                if (!this.isStateSet(16)) continue;
                return false;
            } while (!this.compareAndSet(currentState, 16));
            return true;
        }

        protected boolean acquire(int mask) {
            int currentState;
            do {
                currentState = this.getState();
                if (this.isStateSet(16)) {
                    return false;
                }
                if ((currentState & 8) > mask) {
                    return false;
                }
                if (!this.isStateSet(mask)) continue;
                return false;
            } while (!this.compareAndSet(currentState, currentState | mask));
            return true;
        }

        protected void release(int mask) {
            int currentState;
            while (!this.compareAndSet(currentState = this.getState(), currentState & ~mask)) {
            }
        }

        protected boolean compareAndSet(int expect, int update) {
            boolean wasAlreadyAlive;
            if (!this.state.compareAndSet(expect, update)) {
                return false;
            }
            boolean bl = wasAlreadyAlive = (expect & 3) == 3;
            if (!wasAlreadyAlive && (update & 3) == 3) {
                CountDownLatch latch = this.nextAliveLatch.getAndSet(new CountDownLatch(1));
                latch.countDown();
                TarantoolClientImpl.this.onReconnect();
            } else if (update == 16) {
                this.closedLatch.countDown();
            }
            return true;
        }

        protected void awaitState(int state) throws InterruptedException {
            if (state == 8) {
                this.awaitReconnection();
            } else {
                CountDownLatch latch = this.getStateLatch(state);
                if (latch != null) {
                    latch.await();
                }
            }
        }

        protected boolean awaitState(int state, long timeout, TimeUnit timeUnit) throws InterruptedException {
            CountDownLatch latch = this.getStateLatch(state);
            return latch == null || latch.await(timeout, timeUnit);
        }

        private CountDownLatch getStateLatch(int state) {
            if (state == 16) {
                return this.closedLatch;
            }
            if (state == 3) {
                if (this.isStateSet(16)) {
                    throw new IllegalStateException("State is CLOSED.");
                }
                CountDownLatch latch = this.nextAliveLatch.get();
                return this.isStateSet(3) && TarantoolClientImpl.this.thumbstone == null ? null : latch;
            }
            return null;
        }

        private void awaitReconnection() throws InterruptedException {
            this.connectorLock.lock();
            try {
                while (!this.isStateSet(8)) {
                    this.reconnectRequired.await();
                }
            }
            finally {
                this.connectorLock.unlock();
            }
        }

        private void trySignalForReconnection() {
            if (this.compareAndSet(0, 8)) {
                this.connectorLock.lock();
                try {
                    this.reconnectRequired.signal();
                }
                finally {
                    this.connectorLock.unlock();
                }
            }
        }
    }

    protected class FireAndForgetOps
    extends BaseClientOps<Long> {
        protected FireAndForgetOps() {
        }

        @Override
        protected Long exec(TarantoolRequest request) {
            if (TarantoolClientImpl.this.thumbstone == null) {
                try {
                    return TarantoolClientImpl.this.doExec(request).getId();
                }
                catch (Exception e) {
                    throw new CommunicationException("Execute failed", e);
                }
            }
            throw new CommunicationException("Connection is not alive", TarantoolClientImpl.this.thumbstone);
        }
    }

    protected class SyncOps
    extends BaseClientOps<List<?>> {
        protected SyncOps() {
        }

        @Override
        protected List<?> exec(TarantoolRequest request) {
            return (List)TarantoolClientImpl.this.syncGet(TarantoolClientImpl.this.exec(request));
        }
    }
}

