/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import org.tarantool.CommunicationException;
import org.tarantool.RefreshableSocketProvider;
import org.tarantool.RoundRobinSocketProviderImpl;
import org.tarantool.SocketChannelProvider;
import org.tarantool.TarantoolClientConfig;
import org.tarantool.TarantoolClientImpl;
import org.tarantool.TarantoolClusterClientConfig;
import org.tarantool.TarantoolException;
import org.tarantool.TarantoolOperation;
import org.tarantool.cluster.TarantoolClusterDiscoverer;
import org.tarantool.cluster.TarantoolClusterStoredFunctionDiscoverer;
import org.tarantool.logging.Logger;
import org.tarantool.logging.LoggerFactory;
import org.tarantool.protocol.TarantoolPacket;
import org.tarantool.util.StringUtils;

public class TarantoolClusterClient
extends TarantoolClientImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(TarantoolClusterClient.class);
    private Executor executor;
    private Runnable instancesDiscovererTask;
    private StampedLock discoveryLock = new StampedLock();
    private ConcurrentHashMap<Long, TarantoolOperation> retries = new ConcurrentHashMap();

    public TarantoolClusterClient(TarantoolClusterClientConfig config, String ... addresses) {
        this(config, TarantoolClusterClient.makeClusterSocketProvider(addresses));
    }

    public TarantoolClusterClient(TarantoolClusterClientConfig config, SocketChannelProvider provider) {
        super(provider, (TarantoolClientConfig)config);
        Executor executor = this.executor = config.executor == null ? Executors.newSingleThreadExecutor() : config.executor;
        if (StringUtils.isNotBlank(config.clusterDiscoveryEntryFunction)) {
            this.instancesDiscovererTask = this.createDiscoveryTask(new TarantoolClusterStoredFunctionDiscoverer(config, this));
            int delay = config.clusterDiscoveryDelayMillis > 0 ? config.clusterDiscoveryDelayMillis : 60000;
            this.workExecutor.scheduleWithFixedDelay(this.instancesDiscovererTask, 0L, delay, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    protected boolean isDead(TarantoolOperation operation) {
        if ((this.state.getState() & 0x10) != 0) {
            operation.getResult().completeExceptionally(new CommunicationException("Connection is dead", this.thumbstone));
            return true;
        }
        Exception err = this.thumbstone;
        if (err != null) {
            return this.checkFail(operation, err);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TarantoolOperation registerOperation(TarantoolOperation operation) {
        long stamp = this.discoveryLock.readLock();
        try {
            TarantoolOperation tarantoolOperation = super.registerOperation(operation);
            return tarantoolOperation;
        }
        finally {
            this.discoveryLock.unlock(stamp);
        }
    }

    @Override
    protected void fail(TarantoolOperation operation, Exception cause) {
        this.checkFail(operation, cause);
    }

    protected boolean checkFail(TarantoolOperation operation, Exception cause) {
        if (!this.isTransientError(cause)) {
            operation.getResult().completeExceptionally(cause);
            return true;
        }
        assert (this.retries != null);
        this.retries.put(operation.getId(), operation);
        LOGGER.trace("Request {0} was delayed because of {1}", operation, cause);
        return false;
    }

    @Override
    protected void close(Exception e) {
        super.close(e);
        if (this.retries == null) {
            return;
        }
        for (TarantoolOperation operation : this.retries.values()) {
            operation.getResult().completeExceptionally(e);
        }
    }

    protected boolean isTransientError(Exception e) {
        if (e instanceof CommunicationException) {
            return true;
        }
        if (e instanceof TarantoolException) {
            return ((TarantoolException)e).isTransient();
        }
        return false;
    }

    @Override
    protected void onReconnect() {
        if (this.retries == null || this.executor == null) {
            return;
        }
        ArrayList<TarantoolOperation> delayed = new ArrayList<TarantoolOperation>(this.retries.values());
        ArrayList<TarantoolOperation> reissued = new ArrayList<TarantoolOperation>(this.retries.size());
        this.retries.clear();
        for (TarantoolOperation operation : delayed) {
            if (operation.getResult().isDone()) continue;
            operation.setSentSchemaId(this.schemaMeta.getSchemaVersion());
            this.executor.execute(() -> this.registerOperation(operation));
            reissued.add(operation);
        }
        for (TarantoolOperation operation : reissued) {
            LOGGER.trace("{0} was re-issued after reconnection", operation);
        }
    }

    @Override
    protected void complete(TarantoolPacket packet, TarantoolOperation operation) {
        super.complete(packet, operation);
        RefreshableSocketProvider provider = this.getRefreshableSocketProvider();
        if (provider != null) {
            this.renewConnectionIfRequired(provider.getAddresses());
        }
    }

    protected void onInstancesRefreshed(Set<String> instances) {
        RefreshableSocketProvider provider = this.getRefreshableSocketProvider();
        if (provider != null) {
            provider.refreshAddresses(instances);
            this.renewConnectionIfRequired(provider.getAddresses());
        }
    }

    private RefreshableSocketProvider getRefreshableSocketProvider() {
        return this.socketProvider instanceof RefreshableSocketProvider ? (RefreshableSocketProvider)((Object)this.socketProvider) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renewConnectionIfRequired(Collection<SocketAddress> addresses) {
        if (this.pendingResponsesCount.get() > 0 || !this.isAlive()) {
            return;
        }
        SocketAddress addressInUse = this.getCurrentAddressOrNull();
        if (addressInUse != null && !addresses.contains(addressInUse)) {
            long stamp = this.discoveryLock.tryWriteLock();
            if (!this.discoveryLock.validate(stamp)) {
                return;
            }
            try {
                if (this.pendingResponsesCount.get() == 0) {
                    this.stopIO();
                }
            }
            finally {
                this.discoveryLock.unlock(stamp);
            }
        }
    }

    private SocketAddress getCurrentAddressOrNull() {
        try {
            return this.channel.getRemoteAddress();
        }
        catch (IOException ignored) {
            return null;
        }
    }

    public void refreshInstances() {
        if (this.instancesDiscovererTask != null) {
            this.instancesDiscovererTask.run();
        }
    }

    private static RoundRobinSocketProviderImpl makeClusterSocketProvider(String[] addresses) {
        return new RoundRobinSocketProviderImpl(addresses);
    }

    private Runnable createDiscoveryTask(final TarantoolClusterDiscoverer serviceDiscoverer) {
        return new Runnable(){
            private Set<String> lastInstances;

            @Override
            public synchronized void run() {
                try {
                    Set<String> freshInstances = serviceDiscoverer.getInstances();
                    if (!freshInstances.isEmpty() && !Objects.equals(this.lastInstances, freshInstances)) {
                        this.lastInstances = freshInstances;
                        TarantoolClusterClient.this.onInstancesRefreshed(this.lastInstances);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }
}

