/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.tarantool.Code;
import org.tarantool.CommunicationException;
import org.tarantool.Key;
import org.tarantool.SqlProtoUtils;
import org.tarantool.TarantoolBase;
import org.tarantool.TarantoolRequest;
import org.tarantool.TarantoolSQLOps;
import org.tarantool.protocol.ProtoUtils;
import org.tarantool.protocol.TarantoolPacket;
import org.tarantool.schema.TarantoolSchemaException;
import org.tarantool.schema.TarantoolSchemaMeta;

public class TarantoolConnection
extends TarantoolBase<List<?>>
implements TarantoolSQLOps<Object, Long, List<Map<String, Object>>> {
    protected InputStream in;
    protected OutputStream out;
    protected Socket socket;

    public TarantoolConnection(String username, String password, Socket socket) throws IOException {
        super(username, password, socket);
        this.socket = socket;
        this.out = socket.getOutputStream();
        this.in = socket.getInputStream();
    }

    @Override
    protected List<?> exec(TarantoolRequest request) {
        Object[] args = request.getArguments().toArray();
        TarantoolPacket responsePacket = this.writeAndRead(request.getCode(), args);
        return (List)responsePacket.getBody().get(Key.DATA.getId());
    }

    @Override
    protected TarantoolSchemaMeta getSchemaMeta() {
        throw new TarantoolSchemaException("Schema operations are not supported.");
    }

    protected TarantoolPacket writeAndRead(Code code, Object ... args) {
        try {
            ByteBuffer packet = ProtoUtils.createPacket(this.initialRequestSize, this.msgPackLite, code, (Long)this.syncId.incrementAndGet(), null, args);
            this.out.write(packet.array(), 0, packet.remaining());
            this.out.flush();
            TarantoolPacket responsePacket = ProtoUtils.readPacket(this.in, this.msgPackLite);
            Long c = responsePacket.getCode();
            if (c != 0L) {
                throw this.serverError(c, responsePacket.getError());
            }
            return responsePacket;
        }
        catch (IOException e) {
            this.close();
            throw new CommunicationException("Couldn't execute query", e);
        }
    }

    public void begin() {
        this.call("box.begin", new Object[0]);
    }

    public void commit() {
        this.call("box.commit", new Object[0]);
    }

    public void rollback() {
        this.call("box.rollback", new Object[0]);
    }

    @Override
    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Long update(String sql, Object ... bind) {
        TarantoolPacket pack = this.sql(sql, bind);
        return SqlProtoUtils.getSQLRowCount(pack);
    }

    @Override
    public List<Map<String, Object>> query(String sql, Object ... bind) {
        TarantoolPacket pack = this.sql(sql, bind);
        return SqlProtoUtils.readSqlResult(pack);
    }

    protected TarantoolPacket sql(String sql, Object[] bind) {
        return this.writeAndRead(Code.EXECUTE, Key.SQL_TEXT, sql, Key.SQL_BIND, bind);
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public void setSocketTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    public int getSocketTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }
}

