/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.tarantool.Code;
import org.tarantool.TarantoolRequestArgument;
import org.tarantool.TarantoolThreadDaemonFactory;

public class TarantoolOperation
implements Comparable<TarantoolOperation> {
    private final long id;
    private final Code code;
    private long sentSchemaId;
    private long completedSchemaId;
    private final List<TarantoolRequestArgument> arguments;
    private final CompletableFuture<?> result = new CompletableFuture();
    private final Duration timeout;
    private TarantoolOperation dependedOperation;

    public TarantoolOperation(Code code, List<TarantoolRequestArgument> arguments, long id, long schemaId, Duration timeout) {
        this.id = id;
        this.sentSchemaId = schemaId;
        this.code = Objects.requireNonNull(code);
        this.arguments = new ArrayList<TarantoolRequestArgument>(arguments);
        this.timeout = timeout;
        this.setupTimeout(timeout);
    }

    public TarantoolOperation(Code code, List<TarantoolRequestArgument> arguments, long id, long schemaId, Duration timeout, TarantoolOperation dependedOperation) {
        this.id = id;
        this.sentSchemaId = schemaId;
        this.code = Objects.requireNonNull(code);
        this.arguments = new ArrayList<TarantoolRequestArgument>(arguments);
        this.timeout = timeout;
        this.dependedOperation = dependedOperation;
        this.setupTimeout(timeout);
    }

    public long getId() {
        return this.id;
    }

    public long getSentSchemaId() {
        return this.sentSchemaId;
    }

    public void setSentSchemaId(long sentSchemaId) {
        this.sentSchemaId = sentSchemaId;
    }

    public long getCompletedSchemaId() {
        return this.completedSchemaId;
    }

    public void setCompletedSchemaId(long completedSchemaId) {
        this.completedSchemaId = completedSchemaId;
    }

    public CompletableFuture<?> getResult() {
        return this.result;
    }

    public Code getCode() {
        return this.code;
    }

    public TarantoolOperation getDependedOperation() {
        return this.dependedOperation;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public boolean isSerializable() {
        return this.arguments.stream().allMatch(TarantoolRequestArgument::isSerializable);
    }

    public List<Object> getArguments() {
        return this.arguments.stream().map(TarantoolRequestArgument::getValue).collect(Collectors.toList());
    }

    @Override
    public int compareTo(TarantoolOperation other) {
        return Long.compareUnsigned(this.id, other.id);
    }

    private void setupTimeout(Duration duration) {
        if (duration == null) {
            return;
        }
        if (duration.isNegative()) {
            throw new IllegalArgumentException("Timeout cannot be negative");
        }
        if (duration.isZero() || this.result.isDone()) {
            return;
        }
        ScheduledFuture<?> abandonByTimeoutAction = TimeoutScheduler.EXECUTOR.schedule(() -> {
            if (!this.result.isDone()) {
                this.result.completeExceptionally(new TimeoutException());
            }
        }, duration.toMillis(), TimeUnit.MILLISECONDS);
        this.result.whenComplete((ignored, error) -> {
            if (error == null && !abandonByTimeoutAction.isDone()) {
                abandonByTimeoutAction.cancel(false);
            }
        });
    }

    static class TimeoutScheduler {
        static final ScheduledThreadPoolExecutor EXECUTOR = new ScheduledThreadPoolExecutor(1, new TarantoolThreadDaemonFactory("tarantoolTimeout"));

        TimeoutScheduler() {
        }

        static {
            EXECUTOR.setRemoveOnCancelPolicy(true);
        }
    }
}

