/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.tarantool.Code;
import org.tarantool.TarantoolOperation;
import org.tarantool.TarantoolRequestArgument;

public class TarantoolRequest {
    private Code code;
    private List<TarantoolRequestArgument> arguments;
    private Duration timeout;

    public TarantoolRequest(Code code) {
        this.code = code;
        this.arguments = new ArrayList<TarantoolRequestArgument>();
    }

    public TarantoolRequest(Code code, TarantoolRequestArgument ... arguments) {
        this.code = code;
        this.arguments = Arrays.asList(arguments);
    }

    TarantoolOperation toOperation(long sid, long schemaId) {
        return new TarantoolOperation(this.code, this.arguments, sid, schemaId, this.timeout);
    }

    TarantoolOperation toPreflightOperation(long sid, long schemaId, TarantoolOperation operation) {
        return new TarantoolOperation(this.code, this.arguments, sid, schemaId, this.timeout, operation);
    }

    public Code getCode() {
        return this.code;
    }

    public void setCode(Code code) {
        this.code = code;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    public List<Object> getArguments() {
        return this.arguments.stream().map(TarantoolRequestArgument::getValue).collect(Collectors.toList());
    }

    public void addArguments(TarantoolRequestArgument ... arguments) {
        this.arguments.addAll(Arrays.asList(arguments));
    }
}

