/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool;

import java.util.Objects;
import java.util.function.Supplier;
import org.tarantool.TarantoolRequestArgument;

public class TarantoolRequestArgumentFactory {
    private TarantoolRequestArgumentFactory() {
    }

    public static TarantoolRequestArgument value(Object value) {
        return new SimpleArgument(value);
    }

    public static TarantoolRequestArgument cacheLookupValue(Supplier<Object> supplier) {
        return new LookupArgument(supplier);
    }

    private static class LookupArgument
    implements TarantoolRequestArgument {
        Supplier<Object> lookup;

        LookupArgument(Supplier<Object> lookup) {
            this.lookup = Objects.requireNonNull(lookup);
        }

        @Override
        public boolean isSerializable() {
            try {
                this.lookup.get();
            }
            catch (Exception ignored) {
                return false;
            }
            return true;
        }

        @Override
        public synchronized Object getValue() {
            return this.lookup.get();
        }
    }

    private static class SimpleArgument
    implements TarantoolRequestArgument {
        private Object value;

        SimpleArgument(Object value) {
            Objects.requireNonNull(value);
            this.value = value;
        }

        @Override
        public boolean isSerializable() {
            return true;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }
}

