/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool.cluster;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.tarantool.TarantoolClientImpl;
import org.tarantool.TarantoolClientOps;
import org.tarantool.TarantoolClusterClientConfig;
import org.tarantool.cluster.IllegalDiscoveryFunctionResult;
import org.tarantool.cluster.TarantoolClusterDiscoverer;
import org.tarantool.logging.Logger;
import org.tarantool.logging.LoggerFactory;
import org.tarantool.util.StringUtils;
import org.tarantool.util.TupleTwo;

public class TarantoolClusterStoredFunctionDiscoverer
implements TarantoolClusterDiscoverer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TarantoolClusterStoredFunctionDiscoverer.class);
    private TarantoolClientImpl client;
    private String entryFunction;

    public TarantoolClusterStoredFunctionDiscoverer(TarantoolClusterClientConfig clientConfig, TarantoolClientImpl client) {
        this.client = client;
        this.entryFunction = clientConfig.clusterDiscoveryEntryFunction;
    }

    @Override
    public Set<String> getInstances() {
        TarantoolClientOps<Integer, List<?>, Object, TupleTwo<List<?>, Long>> syncOperations = this.client.unsafeSchemaOps();
        TupleTwo<List<?>, Long> result = syncOperations.call(this.entryFunction, new Object[0]);
        return this.checkAndFilterAddresses(result.getFirst());
    }

    private Set<String> checkAndFilterAddresses(List<?> result) {
        if (result == null || result.isEmpty()) {
            throw new IllegalDiscoveryFunctionResult("Discovery function returned no data");
        }
        if (!(result.get(0) instanceof List)) {
            throw new IllegalDiscoveryFunctionResult("The first value must be an array of strings");
        }
        LinkedHashSet<String> passed = new LinkedHashSet<String>();
        LinkedHashSet<String> skipped = new LinkedHashSet<String>();
        for (Object item : (List)result.get(0)) {
            if (!(item instanceof String)) {
                skipped.add(item.toString());
                continue;
            }
            String s = item.toString();
            if (!StringUtils.isBlank(s) && this.isAddress(s)) {
                passed.add(s);
                continue;
            }
            skipped.add(s);
        }
        if (!skipped.isEmpty()) {
            LOGGER.warn("Some of the addresses were skipped because of unsupported format: {0}", skipped);
        }
        return passed;
    }

    private boolean isAddress(String address) {
        if (address.endsWith(":")) {
            return false;
        }
        String[] addressParts = address.split(":");
        if (addressParts.length > 2) {
            return false;
        }
        if (addressParts.length == 2) {
            try {
                int port = Integer.parseInt(addressParts[1]);
                return port > 0 && port < 65536;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }
}

