/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool.jdbc;

import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLNonTransientException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.tarantool.CommunicationException;
import org.tarantool.SocketChannelProvider;
import org.tarantool.SqlProtoUtils;
import org.tarantool.TarantoolClientConfig;
import org.tarantool.TarantoolClientImpl;
import org.tarantool.TarantoolOperation;
import org.tarantool.TarantoolRequest;
import org.tarantool.jdbc.SQLBatchResultHolder;
import org.tarantool.jdbc.SQLDatabaseMetadata;
import org.tarantool.jdbc.SQLDriver;
import org.tarantool.jdbc.SQLMsgPackLite;
import org.tarantool.jdbc.SQLPreparedStatement;
import org.tarantool.jdbc.SQLProperty;
import org.tarantool.jdbc.SQLQueryHolder;
import org.tarantool.jdbc.SQLResultHolder;
import org.tarantool.jdbc.SQLStatement;
import org.tarantool.jdbc.StatementTimeoutException;
import org.tarantool.jdbc.TarantoolConnection;
import org.tarantool.protocol.TarantoolPacket;
import org.tarantool.util.JdbcConstants;
import org.tarantool.util.SQLStates;

public class SQLConnection
implements TarantoolConnection {
    private static final int UNSET_HOLDABILITY = 0;
    private static final String PING_QUERY = "SELECT 1";
    private final SQLTarantoolClientImpl client;
    private final String url;
    private final Properties properties;
    private DatabaseMetaData cachedMetadata;
    private int resultSetHoldability = 0;

    public SQLConnection(String url, Properties properties) throws SQLException {
        this.url = url;
        this.properties = properties;
        try {
            this.client = this.makeSqlClient(this.makeAddress(properties), this.makeConfigFromProperties(properties));
        }
        catch (Exception e) {
            throw new SQLException("Couldn't initiate connection using " + SQLDriver.diagProperties(properties), e);
        }
    }

    protected SQLTarantoolClientImpl makeSqlClient(String address, TarantoolClientConfig config) {
        return new SQLTarantoolClientImpl(address, config);
    }

    private String makeAddress(Properties properties) throws SQLException {
        String host = SQLProperty.HOST.getString(properties);
        int port = SQLProperty.PORT.getInt(properties);
        return host + ":" + port;
    }

    private TarantoolClientConfig makeConfigFromProperties(Properties properties) throws SQLException {
        TarantoolClientConfig clientConfig = new TarantoolClientConfig();
        clientConfig.username = SQLProperty.USER.getString(properties);
        clientConfig.password = SQLProperty.PASSWORD.getString(properties);
        clientConfig.operationExpiryTimeMillis = SQLProperty.QUERY_TIMEOUT.getInt(properties);
        clientConfig.initTimeoutMillis = SQLProperty.LOGIN_TIMEOUT.getInt(properties);
        return clientConfig;
    }

    @Override
    public void commit() throws SQLException {
        this.checkNotClosed();
        if (this.getAutoCommit()) {
            throw new SQLNonTransientException("Cannot commit when auto-commit is enabled.", SQLStates.INVALID_TRANSACTION_STATE.getSqlState());
        }
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkNotClosed();
        this.checkStatementParams(resultSetType, resultSetConcurrency, resultSetHoldability);
        return new SQLStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkNotClosed();
        this.checkStatementParams(resultSetType, resultSetConcurrency, resultSetHoldability);
        return new SQLPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkNotClosed();
        JdbcConstants.checkGeneratedKeysConstant(autoGeneratedKeys);
        return new SQLPreparedStatement(this, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkNotClosed();
        if (!autoCommit) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkNotClosed();
        return true;
    }

    @Override
    public void close() throws SQLException {
        this.client.close();
    }

    @Override
    public void rollback() throws SQLException {
        this.checkNotClosed();
        if (this.getAutoCommit()) {
            throw new SQLNonTransientException("Cannot rollback when auto-commit is enabled.", SQLStates.INVALID_TRANSACTION_STATE.getSqlState());
        }
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkNotClosed();
        if (this.getAutoCommit()) {
            throw new SQLNonTransientException("Cannot roll back to a savepoint when auto-commit is enabled.", SQLStates.INVALID_TRANSACTION_STATE.getSqlState());
        }
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.client.isClosed();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkNotClosed();
        if (this.getAutoCommit()) {
            throw new SQLNonTransientException("Cannot set a savepoint when auto-commit is enabled.", SQLStates.INVALID_TRANSACTION_STATE.getSqlState());
        }
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkNotClosed();
        if (this.getAutoCommit()) {
            throw new SQLNonTransientException("Cannot set a savepoint when auto-commit is enabled.", SQLStates.INVALID_TRANSACTION_STATE.getSqlState());
        }
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkNotClosed();
        if (this.cachedMetadata == null) {
            this.cachedMetadata = new SQLDatabaseMetadata(this);
        }
        return this.cachedMetadata;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkNotClosed();
        if (level != 0) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkNotClosed();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkNotClosed();
        this.checkHoldabilitySupport(holdability);
        this.resultSetHoldability = holdability;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkNotClosed();
        if (this.resultSetHoldability == 0) {
            this.resultSetHoldability = this.getMetaData().getResultSetHoldability();
        }
        return this.resultSetHoldability;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLNonTransientException("Timeout cannot be negative", SQLStates.INVALID_PARAMETER_VALUE.getSqlState());
        }
        if (this.isClosed()) {
            return false;
        }
        return this.checkConnection(timeout);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkConnection(int timeout) {
        try (Statement pingStatement = this.createStatement();){
            pingStatement.setQueryTimeout(timeout);
            ResultSet resultSet = pingStatement.executeQuery(PING_QUERY);
            boolean isValid = resultSet.next() && resultSet.getInt(1) == 1;
            resultSet.close();
            boolean bl = isValid;
            return bl;
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkNotClosed();
        if (milliseconds < 0) {
            throw new SQLException("Network timeout cannot be negative.");
        }
        this.client.setOperationTimeout(milliseconds);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.checkNotClosed();
        }
        catch (SQLException cause) {
            this.throwUnknownReasonClientProperties("Connection is closed", Collections.singleton(name), cause);
        }
        this.throwUnknownClientProperties(Collections.singleton(name));
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkNotClosed();
        }
        catch (SQLException cause) {
            this.throwUnknownReasonClientProperties("Connection is closed", properties.keySet(), cause);
        }
        this.throwUnknownClientProperties(properties.keySet());
    }

    private void throwUnknownReasonClientProperties(String reason, Collection<Object> properties, SQLException cause) throws SQLClientInfoException {
        HashMap<String, ClientInfoStatus> failedProperties = new HashMap<String, ClientInfoStatus>();
        properties.forEach(property -> failedProperties.put(property.toString(), ClientInfoStatus.REASON_UNKNOWN));
        throw new SQLClientInfoException(reason, cause.getSQLState(), failedProperties, (Throwable)cause);
    }

    private void throwUnknownClientProperties(Collection<Object> properties) throws SQLClientInfoException {
        HashMap<String, ClientInfoStatus> failedProperties = new HashMap<String, ClientInfoStatus>();
        properties.forEach(property -> failedProperties.put(property.toString(), ClientInfoStatus.REASON_UNKNOWN_PROPERTY));
        throw new SQLClientInfoException(failedProperties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkNotClosed();
        return new Properties();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.isClosed()) {
            return;
        }
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkNotClosed();
        return (int)this.client.getOperationTimeout();
    }

    @Override
    public SQLResultHolder execute(long timeout, SQLQueryHolder query) throws SQLException {
        this.checkNotClosed();
        return this.useNetworkTimeout(timeout) ? this.executeWithNetworkTimeout(query) : this.executeWithQueryTimeout(timeout, query);
    }

    @Override
    public SQLBatchResultHolder executeBatch(long timeout, List<SQLQueryHolder> queries) throws SQLException {
        this.checkNotClosed();
        SQLTarantoolClientImpl.SQLRawOps sqlOps = this.client.sqlRawOps();
        SQLBatchResultHolder batchResult = this.useNetworkTimeout(timeout) ? sqlOps.executeBatch(queries) : sqlOps.executeBatch(timeout, queries);
        return batchResult;
    }

    private boolean useNetworkTimeout(long timeout) throws SQLException {
        int networkTimeout = this.getNetworkTimeout();
        return timeout == 0L || networkTimeout > 0 && (long)networkTimeout < timeout;
    }

    private SQLResultHolder executeWithNetworkTimeout(SQLQueryHolder query) throws SQLException {
        try {
            return this.client.sqlRawOps().execute(query);
        }
        catch (Exception e) {
            this.handleException(e);
            throw new SQLException(SQLConnection.formatError(query), e);
        }
    }

    private SQLResultHolder executeWithQueryTimeout(long timeout, SQLQueryHolder query) throws SQLException {
        try {
            return this.client.sqlRawOps().execute(timeout, query);
        }
        catch (Exception e) {
            if (e.getCause() instanceof TimeoutException) {
                throw new StatementTimeoutException(SQLConnection.formatError(query), e.getCause());
            }
            this.handleException(e);
            throw new SQLException(SQLConnection.formatError(query), e);
        }
    }

    @Override
    public <T> T unwrap(Class<T> type) throws SQLException {
        if (this.isWrapperFor(type)) {
            return type.cast(this);
        }
        throw new SQLNonTransientException("Connection does not wrap " + type.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> type) throws SQLException {
        return type.isAssignableFrom(this.getClass());
    }

    protected List<?> nativeSelect(Integer space, Integer index, List<?> key, int offset, int limit, int iterator) throws SQLException {
        this.checkNotClosed();
        try {
            return this.client.syncOps().select(space, index, key, offset, limit, iterator);
        }
        catch (Exception e) {
            this.handleException(e);
            throw new SQLException(e);
        }
    }

    protected String getServerVersion() {
        return this.client.getServerVersion();
    }

    private void handleException(Exception e) {
        if (e instanceof CommunicationException || e instanceof IOException || e.getCause() instanceof TimeoutException) {
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void checkNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLNonTransientConnectionException("Connection is closed.", SQLStates.CONNECTION_DOES_NOT_EXIST.getSqlState());
        }
    }

    String getUrl() {
        return this.url;
    }

    Properties getProperties() {
        return this.properties;
    }

    private void checkStatementParams(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkResultSetType(resultSetType);
        this.checkResultSetConcurrency(resultSetType, resultSetConcurrency);
        this.checkHoldabilitySupport(resultSetHoldability);
    }

    private void checkResultSetType(int resultSetType) throws SQLException {
        if (resultSetType != 1003 && resultSetType != 1004 && resultSetType != 1005) {
            throw new SQLNonTransientException("", SQLStates.INVALID_PARAMETER_VALUE.getSqlState());
        }
        if (!this.getMetaData().supportsResultSetType(resultSetType)) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    private void checkResultSetConcurrency(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetConcurrency != 1007 && resultSetConcurrency != 1008) {
            throw new SQLNonTransientException("", SQLStates.INVALID_PARAMETER_VALUE.getSqlState());
        }
        if (!this.getMetaData().supportsResultSetConcurrency(resultSetType, resultSetConcurrency)) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    private void checkHoldabilitySupport(int holdability) throws SQLException {
        JdbcConstants.checkHoldabilityConstant(holdability);
        if (!this.getMetaData().supportsResultSetHoldability(holdability)) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    private static String formatError(SQLQueryHolder query) {
        return "Failed to execute SQL: " + query.getQuery() + ", params: " + query.getParams();
    }

    static class SQLTarantoolClientImpl
    extends TarantoolClientImpl {
        final SQLRawOps sqlRawOps = new SQLRawOps(this){
            final /* synthetic */ SQLTarantoolClientImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public SQLResultHolder execute(SQLQueryHolder query) {
                return (SQLResultHolder)this.this$0.syncGet(this.this$0.executeQuery(query));
            }

            @Override
            public SQLResultHolder execute(long timeoutMillis, SQLQueryHolder query) {
                return (SQLResultHolder)this.this$0.syncGet(this.this$0.executeQuery(query, timeoutMillis));
            }

            @Override
            public SQLBatchResultHolder executeBatch(List<SQLQueryHolder> queries) {
                return this.executeInternal(queries, query -> this.this$0.executeQuery(query));
            }

            @Override
            public SQLBatchResultHolder executeBatch(long timeoutMillis, List<SQLQueryHolder> queries) {
                return this.executeInternal(queries, query -> this.this$0.executeQuery(query, timeoutMillis));
            }

            private SQLBatchResultHolder executeInternal(List<SQLQueryHolder> queries, Function<SQLQueryHolder, Future<?>> fetcher) {
                ArrayList sqlFutures = new ArrayList();
                for (SQLQueryHolder query : queries) {
                    sqlFutures.add(fetcher.apply(query));
                }
                Exception lastError = null;
                ArrayList<SQLResultHolder> items = new ArrayList<SQLResultHolder>(queries.size());
                for (Future future : sqlFutures) {
                    try {
                        SQLResultHolder result = (SQLResultHolder)this.this$0.syncGet(future);
                        if (result.isQueryResult()) {
                            lastError = new SQLException("Result set is not allowed in the batch response", SQLStates.TOO_MANY_RESULTS.getSqlState());
                        }
                        items.add(result);
                    }
                    catch (RuntimeException e) {
                        items.add(SQLResultHolder.ofEmptyQuery());
                        lastError = e;
                    }
                }
                return new SQLBatchResultHolder(items, lastError);
            }
        };

        private Future<?> executeQuery(SQLQueryHolder queryHolder) {
            return this.exec(this.makeSqlRequest(queryHolder.getQuery(), queryHolder.getParams()));
        }

        private Future<?> executeQuery(SQLQueryHolder queryHolder, long timeoutMillis) {
            TarantoolRequest request = this.makeSqlRequest(queryHolder.getQuery(), queryHolder.getParams());
            request.setTimeout(Duration.of(timeoutMillis, ChronoUnit.MILLIS));
            return this.exec(request);
        }

        SQLTarantoolClientImpl(String address, TarantoolClientConfig config) {
            super(address, config);
            this.msgPackLite = SQLMsgPackLite.INSTANCE;
        }

        SQLTarantoolClientImpl(SocketChannelProvider socketProvider, TarantoolClientConfig config) {
            super(socketProvider, config);
            this.msgPackLite = SQLMsgPackLite.INSTANCE;
        }

        SQLRawOps sqlRawOps() {
            return this.sqlRawOps;
        }

        @Override
        protected void completeSql(TarantoolOperation operation, TarantoolPacket pack) {
            Long rowCount = SqlProtoUtils.getSQLRowCount(pack);
            SQLResultHolder result = rowCount == null ? SQLResultHolder.ofQuery(SqlProtoUtils.getSQLMetadata(pack), SqlProtoUtils.getSQLData(pack)) : SQLResultHolder.ofUpdate(rowCount.intValue(), SqlProtoUtils.getSQLAutoIncrementIds(pack));
            operation.getResult().complete(result);
        }

        static interface SQLRawOps {
            public SQLResultHolder execute(SQLQueryHolder var1);

            public SQLResultHolder execute(long var1, SQLQueryHolder var3);

            public SQLBatchResultHolder executeBatch(List<SQLQueryHolder> var1);

            public SQLBatchResultHolder executeBatch(long var1, List<SQLQueryHolder> var3);
        }
    }
}

