/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool.jdbc;

import java.net.URI;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.tarantool.SocketChannelProvider;
import org.tarantool.TarantoolClientConfig;
import org.tarantool.jdbc.SQLConnection;
import org.tarantool.jdbc.SQLProperty;
import org.tarantool.util.SQLStates;

public class SQLDriver
implements Driver {
    private final Map<String, SocketChannelProvider> providerCache = new ConcurrentHashMap<String, SocketChannelProvider>();

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url == null) {
            throw new SQLException("Url must not be null");
        }
        if (!this.acceptsURL(url)) {
            return null;
        }
        URI uri = URI.create(url);
        Properties urlProperties = this.parseQueryString(uri, info);
        String providerClassName = SQLProperty.SOCKET_CHANNEL_PROVIDER.getString(urlProperties);
        if (providerClassName == null) {
            return new SQLConnection(url, urlProperties);
        }
        final SocketChannelProvider provider = this.getSocketProviderInstance(providerClassName);
        return new SQLConnection(url, urlProperties){

            @Override
            protected SQLConnection.SQLTarantoolClientImpl makeSqlClient(String address, TarantoolClientConfig config) {
                return new SQLConnection.SQLTarantoolClientImpl(provider, config);
            }
        };
    }

    protected Properties parseQueryString(URI uri, Properties info) throws SQLException {
        int port;
        Properties urlProperties = new Properties();
        String userInfo = (uri = URI.create(uri.getSchemeSpecificPart())).getUserInfo();
        if (userInfo != null) {
            int i = userInfo.indexOf(58);
            if (i < 0) {
                SQLProperty.USER.setString(urlProperties, userInfo);
            } else {
                SQLProperty.USER.setString(urlProperties, userInfo.substring(0, i));
                SQLProperty.PASSWORD.setString(urlProperties, userInfo.substring(i + 1));
            }
        }
        if (uri.getQuery() != null) {
            String[] parts;
            for (String part : parts = uri.getQuery().split("&")) {
                int i = part.indexOf("=");
                if (i > -1) {
                    urlProperties.put(part.substring(0, i), part.substring(i + 1));
                    continue;
                }
                urlProperties.put(part, "");
            }
        }
        if (uri.getHost() != null) {
            urlProperties.setProperty(SQLProperty.HOST.getName(), uri.getHost());
        }
        if (uri.getPort() >= 0) {
            urlProperties.setProperty(SQLProperty.PORT.getName(), String.valueOf(uri.getPort()));
        }
        if (info != null) {
            urlProperties.putAll((Map<?, ?>)info);
        }
        if ((port = SQLProperty.PORT.getInt(urlProperties)) <= 0 || port > 65535) {
            throw new SQLException("Port is out of range: " + port, SQLStates.INVALID_PARAMETER_VALUE.getSqlState());
        }
        this.checkTimeout(SQLProperty.LOGIN_TIMEOUT, urlProperties);
        this.checkTimeout(SQLProperty.QUERY_TIMEOUT, urlProperties);
        return urlProperties;
    }

    private void checkTimeout(SQLProperty sqlProperty, Properties properties) throws SQLException {
        int timeout = sqlProperty.getInt(properties);
        if (timeout < 0) {
            throw new SQLException("Property " + sqlProperty.getName() + " must not be negative.", SQLStates.INVALID_PARAMETER_VALUE.getSqlState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SocketChannelProvider getSocketProviderInstance(String className) throws SQLException {
        SocketChannelProvider provider = this.providerCache.get(className);
        if (provider == null) {
            SQLDriver sQLDriver = this;
            synchronized (sQLDriver) {
                provider = this.providerCache.get(className);
                if (provider == null) {
                    try {
                        Class<?> cls = Class.forName(className);
                        if (SocketChannelProvider.class.isAssignableFrom(cls)) {
                            provider = (SocketChannelProvider)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            this.providerCache.put(className, provider);
                        }
                    }
                    catch (Exception e) {
                        throw new SQLException("Couldn't instantiate socket provider: " + className, e);
                    }
                }
            }
        }
        if (provider == null) {
            throw new SQLException(String.format("The socket provider %s does not implement %s", className, SocketChannelProvider.class.getCanonicalName()));
        }
        return provider;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.toLowerCase().startsWith("jdbc:tarantool:");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        try {
            URI uri = new URI(url);
            Properties properties = this.parseQueryString(uri, info);
            SQLProperty[] sqlProperties = SQLProperty.values();
            DriverPropertyInfo[] propertyInfoList = new DriverPropertyInfo[sqlProperties.length];
            for (int i = 0; i < sqlProperties.length; ++i) {
                SQLProperty sqlProperty = sqlProperties[i];
                String value = sqlProperty.getString(properties);
                DriverPropertyInfo propertyInfo = new DriverPropertyInfo(sqlProperty.getName(), value);
                propertyInfo.required = sqlProperty.isRequired();
                propertyInfo.description = sqlProperty.getDescription();
                propertyInfo.choices = sqlProperty.getChoices();
                propertyInfoList[i] = propertyInfo;
            }
            return propertyInfoList;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    protected static String diagProperties(Properties props) {
        String userProp = SQLProperty.USER.getName();
        String passwordProp = SQLProperty.PASSWORD.getName();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(e.getKey());
            sb.append('=');
            sb.append(userProp.equals(e.getKey()) || passwordProp.equals(e.getKey()) ? "*****" : e.getValue().toString());
        }
        return sb.toString();
    }

    static {
        try {
            DriverManager.registerDriver(new SQLDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException("Can't register driver!");
        }
    }
}

