/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tarantool.jdbc.SQLConnection;
import org.tarantool.jdbc.SQLQueryHolder;
import org.tarantool.jdbc.SQLStatement;
import org.tarantool.util.SQLStates;

public class SQLPreparedStatement
extends SQLStatement
implements PreparedStatement {
    private static final String INVALID_CALL_MESSAGE = "The method cannot be called on a PreparedStatement.";
    private static final int STREAM_WRITE_CHUNK_SIZE = 4096;
    private final String sql;
    private final Map<Integer, Object> parameters;
    private final int autoGeneratedKeys;
    private List<Map<Integer, Object>> batchParameters = new ArrayList<Map<Integer, Object>>();

    public SQLPreparedStatement(SQLConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        super(connection);
        this.sql = sql;
        this.parameters = new HashMap<Integer, Object>();
        this.autoGeneratedKeys = autoGeneratedKeys;
        this.setPoolable(true);
    }

    public SQLPreparedStatement(SQLConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.sql = sql;
        this.parameters = new HashMap<Integer, Object>();
        this.autoGeneratedKeys = 2;
        this.setPoolable(true);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkNotClosed();
        if (!this.executeInternal(this.autoGeneratedKeys, this.sql, this.toParametersList(this.parameters))) {
            throw new SQLException("No results were returned", SQLStates.NO_DATA.getSqlState());
        }
        return this.resultSet;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkNotClosed();
        throw new SQLException(INVALID_CALL_MESSAGE);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkNotClosed();
        if (this.executeInternal(this.autoGeneratedKeys, this.sql, this.toParametersList(this.parameters))) {
            throw new SQLException("Result was returned but nothing was expected", SQLStates.TOO_MANY_RESULTS.getSqlState());
        }
        return this.updateCount;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkNotClosed();
        throw new SQLException(INVALID_CALL_MESSAGE);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setParameter(parameterIndex, null);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setParameter(parameterIndex, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean parameterValue) throws SQLException {
        this.setParameter(parameterIndex, parameterValue);
    }

    @Override
    public void setByte(int parameterIndex, byte parameterValue) throws SQLException {
        this.setParameter(parameterIndex, parameterValue);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] parameterValue) throws SQLException {
        this.setParameter(parameterIndex, parameterValue);
    }

    @Override
    public void setShort(int parameterIndex, short parameterValue) throws SQLException {
        this.setParameter(parameterIndex, parameterValue);
    }

    @Override
    public void setInt(int parameterIndex, int parameterValue) throws SQLException {
        this.setParameter(parameterIndex, parameterValue);
    }

    @Override
    public void setLong(int parameterIndex, long parameterValue) throws SQLException {
        this.setParameter(parameterIndex, parameterValue);
    }

    @Override
    public void setFloat(int parameterIndex, float parameterValue) throws SQLException {
        this.setParameter(parameterIndex, Float.valueOf(parameterValue));
    }

    @Override
    public void setDouble(int parameterIndex, double parameterValue) throws SQLException {
        this.setParameter(parameterIndex, parameterValue);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal parameterValue) throws SQLException {
        this.setParameter(parameterIndex, parameterValue);
    }

    @Override
    public void setString(int parameterIndex, String parameterValue) throws SQLException {
        this.setParameter(parameterIndex, parameterValue);
    }

    @Override
    public void setDate(int parameterIndex, Date parameterValue) throws SQLException {
        this.setParameter(parameterIndex, parameterValue);
    }

    @Override
    public void setDate(int parameterIndex, Date parameterValue, Calendar calendar) throws SQLException {
        this.setParameter(parameterIndex, parameterValue);
    }

    @Override
    public void setTime(int parameterIndex, Time parameterValue) throws SQLException {
        this.setParameter(parameterIndex, parameterValue);
    }

    @Override
    public void setTime(int parameterIndex, Time parameterValue, Calendar calendar) throws SQLException {
        this.setParameter(parameterIndex, parameterValue);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp parameterValue) throws SQLException {
        this.setParameter(parameterIndex, parameterValue);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp parameterValue, Calendar calendar) throws SQLException {
        this.setParameter(parameterIndex, parameterValue);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream parameterValue, int length) throws SQLException {
        this.setAsciiStream(parameterIndex, parameterValue, (long)length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream parameterValue) throws SQLException {
        this.setCharStream(parameterIndex, parameterValue, Integer.MAX_VALUE, "ASCII");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream parameterValue, long length) throws SQLException {
        this.ensureLengthLowerBound(length);
        this.setCharStream(parameterIndex, parameterValue, length, "ASCII");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream parameterValue, int length) throws SQLException {
        this.ensureLengthLowerBound(length);
        this.setCharStream(parameterIndex, parameterValue, length, "UTF-8");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream parameterValue, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, parameterValue, (long)length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream parameterValue, long length) throws SQLException {
        this.ensureLengthLowerBound(length);
        this.setBinStream(parameterIndex, parameterValue, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream parameterValue) throws SQLException {
        this.setBinStream(parameterIndex, parameterValue, Integer.MAX_VALUE);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.parameters.clear();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, -1);
    }

    @Override
    public void setObject(int parameterIndex, Object value) throws SQLException {
        this.setParameter(parameterIndex, value);
    }

    @Override
    public void setObject(int parameterIndex, Object parameterValue, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setParameter(parameterIndex, parameterValue);
    }

    private void setParameter(int parameterIndex, Object value) throws SQLException {
        this.checkNotClosed();
        this.parameters.put(parameterIndex, value);
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkNotClosed();
        return this.executeInternal(this.autoGeneratedKeys, this.sql, this.toParametersList(this.parameters));
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkNotClosed();
        throw new SQLException(INVALID_CALL_MESSAGE);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, (long)length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ensureLengthLowerBound(length);
        this.setCharStream(parameterIndex, reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setCharStream(parameterIndex, reader, Integer.MAX_VALUE);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.resultSet != null && !this.resultSet.isClosed()) {
            return this.resultSet.getMetaData();
        }
        return null;
    }

    @Override
    public void setURL(int parameterIndex, URL parameterValue) throws SQLException {
        this.setParameter(parameterIndex, parameterValue.toString());
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNString(int parameterIndex, String parameterValue) throws SQLException {
        this.setParameter(parameterIndex, parameterValue);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkNotClosed();
        throw new SQLException(INVALID_CALL_MESSAGE);
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkNotClosed();
        this.batchParameters.add(new HashMap<Integer, Object>(this.parameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.checkNotClosed();
        try {
            ArrayList<SQLQueryHolder> queries = new ArrayList<SQLQueryHolder>();
            for (Map<Integer, Object> p : this.batchParameters) {
                SQLQueryHolder of = SQLQueryHolder.of(this.sql, this.toParametersList(p));
                queries.add(of);
            }
            Object object = this.executeBatchInternal(queries);
            return object;
        }
        finally {
            this.batchParameters.clear();
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkNotClosed();
        this.batchParameters.clear();
    }

    private Object[] toParametersList(Map<Integer, Object> parameters) throws SQLException {
        Object[] objects = new Object[parameters.size()];
        for (int i = 1; i <= parameters.size(); ++i) {
            if (!parameters.containsKey(i)) {
                throw new SQLException("Parameter " + i + " is missing");
            }
            objects[i - 1] = parameters.get(i);
        }
        return objects;
    }

    private void ensureLengthLowerBound(long length) throws SQLException {
        if (length < 0L) {
            throw new SQLException("Stream size cannot be negative", SQLStates.INVALID_PARAMETER_VALUE.getSqlState());
        }
    }

    private void ensureLengthUpperBound(long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new SQLException("Stream size is too large", SQLStates.INVALID_PARAMETER_VALUE.getSqlState());
        }
    }

    private void setCharStream(int parameterIndex, InputStream parameterValue, long length, String encoding) throws SQLException {
        this.ensureLengthUpperBound(length);
        try {
            byte[] bytes = this.convertToBytes(parameterValue, length);
            this.setParameter(parameterIndex, new String(bytes, 0, bytes.length, encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("Unsupported encoding", SQLStates.INVALID_PARAMETER_VALUE.getSqlState(), e);
        }
    }

    private void setCharStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ensureLengthUpperBound(length);
        try {
            int charsRead;
            StringBuilder value = new StringBuilder(4096);
            char[] buffer = new char[4096];
            int totalRead = 0;
            while ((long)totalRead < length && (charsRead = reader.read(buffer, 0, (int)Math.min(length - (long)totalRead, 4096L))) != -1) {
                value.append(buffer, 0, charsRead);
                totalRead += charsRead;
            }
            this.setParameter(parameterIndex, value.toString());
        }
        catch (IOException e) {
            throw new SQLException("Cannot read from the reader", SQLStates.INVALID_PARAMETER_VALUE.getSqlState(), e);
        }
    }

    private void setBinStream(int parameterIndex, InputStream parameterValue, long length) throws SQLException {
        this.ensureLengthUpperBound(length);
        this.setBytes(parameterIndex, this.convertToBytes(parameterValue, length));
    }

    private byte[] convertToBytes(InputStream parameterValue, long length) throws SQLException {
        try {
            int bytesRead;
            int totalRead = 0;
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
            while ((long)totalRead < length && (bytesRead = parameterValue.read(buffer, 0, (int)Math.min(length - (long)totalRead, 4096L))) != -1) {
                outputStream.write(buffer, 0, bytesRead);
                totalRead += bytesRead;
            }
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new SQLException("Cannot read stream", SQLStates.INVALID_PARAMETER_VALUE.getSqlState(), e);
        }
    }
}

