/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool.jdbc;

import java.sql.SQLException;
import java.util.Properties;
import org.tarantool.util.SQLStates;

public enum SQLProperty {
    HOST("host", "Tarantool server host", "localhost", null, true),
    PORT("port", "Tarantool server port", "3301", null, true),
    SOCKET_CHANNEL_PROVIDER("socketChannelProvider", "SocketProvider class implements org.tarantool.SocketChannelProvider", null, null, false),
    USER("user", "Username to connect", null, null, false),
    PASSWORD("password", "User password to connect", null, null, false),
    LOGIN_TIMEOUT("loginTimeout", "The number of milliseconds to wait for connection establishment. The default system value is 60000 (1 minute).", "60000", null, false),
    QUERY_TIMEOUT("queryTimeout", "The number of milliseconds to wait before a timeout is occurred for the query. The default value is 0 (infinite) timeout.", "0", null, false);

    private final String name;
    private final String description;
    private final String defaultValue;
    private final String[] choices;
    private final boolean required;

    private SQLProperty(String name, String description, String defaultValue, String[] choices, boolean required) {
        this.name = name;
        this.description = description;
        this.defaultValue = defaultValue;
        this.choices = choices;
        this.required = required;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public int getDefaultIntValue() {
        return Integer.parseInt(this.defaultValue);
    }

    public boolean isRequired() {
        return this.required;
    }

    public String[] getChoices() {
        return this.choices;
    }

    public String getString(Properties properties) {
        return properties.getProperty(this.name, this.defaultValue);
    }

    public void setString(Properties properties, String value) {
        if (value == null) {
            properties.remove(this.name);
        } else {
            properties.setProperty(this.name, value);
        }
    }

    public int getInt(Properties properties) throws SQLException {
        String property = this.getString(properties);
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException exception) {
            throw new SQLException("Property " + this.name + " must be a valid number.", SQLStates.INVALID_PARAMETER_VALUE.getSqlState(), exception);
        }
    }

    public void setInt(Properties properties, int value) {
        this.setString(properties, Integer.toString(value));
    }
}

