/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool.jdbc;

import java.util.Collections;
import java.util.List;
import org.tarantool.SqlProtoUtils;

public class SQLResultHolder {
    public static final int NO_UPDATE_COUNT = -1;
    private final List<SqlProtoUtils.SQLMetaData> sqlMetadata;
    private final List<List<Object>> rows;
    private final int updateCount;
    private final List<Integer> generatedIds;

    public SQLResultHolder(List<SqlProtoUtils.SQLMetaData> sqlMetadata, List<List<Object>> rows, int updateCount, List<Integer> generatedIds) {
        this.sqlMetadata = sqlMetadata;
        this.rows = rows;
        this.updateCount = updateCount;
        this.generatedIds = generatedIds;
    }

    public static SQLResultHolder ofQuery(List<SqlProtoUtils.SQLMetaData> sqlMetadata, List<List<Object>> rows) {
        return new SQLResultHolder(sqlMetadata, rows, -1, Collections.emptyList());
    }

    public static SQLResultHolder ofEmptyQuery() {
        return SQLResultHolder.ofQuery(Collections.emptyList(), Collections.emptyList());
    }

    public static SQLResultHolder ofUpdate(int updateCount, List<Integer> generatedIds) {
        return new SQLResultHolder(null, null, updateCount, generatedIds);
    }

    public List<SqlProtoUtils.SQLMetaData> getSqlMetadata() {
        return this.sqlMetadata;
    }

    public List<List<Object>> getRows() {
        return this.rows;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public List<Integer> getGeneratedIds() {
        return this.generatedIds;
    }

    public boolean isQueryResult() {
        return this.sqlMetadata != null && this.rows != null;
    }
}

