/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool.jdbc;

import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.util.List;
import org.tarantool.SqlProtoUtils;
import org.tarantool.jdbc.TarantoolResultSetMetaData;
import org.tarantool.util.SQLStates;

public class SQLResultSetMetaData
implements TarantoolResultSetMetaData {
    private final List<SqlProtoUtils.SQLMetaData> sqlMetadata;
    private final boolean readOnly;

    public SQLResultSetMetaData(List<SqlProtoUtils.SQLMetaData> sqlMetaData, boolean readOnly) {
        this.sqlMetadata = sqlMetaData;
        this.readOnly = readOnly;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.sqlMetadata.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.checkColumnIndex(column);
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.sqlMetadata.get(column - 1).getType().isCaseSensitive();
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        this.checkColumnIndex(column);
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        this.checkColumnIndex(column);
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        this.checkColumnIndex(column);
        return 2;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.sqlMetadata.get(column - 1).getType().isSigned();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.sqlMetadata.get(column - 1).getType().getDisplaySize();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.sqlMetadata.get(column - 1).getName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.sqlMetadata.get(column - 1).getName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.sqlMetadata.get(column - 1).getType().getPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.sqlMetadata.get(column - 1).getType().getScale();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return "";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.sqlMetadata.get(column - 1).getType().getJdbcType().getTypeNumber();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.sqlMetadata.get(column - 1).getType().getTypeName();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.readOnly;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.sqlMetadata.get(column - 1).getType().getJdbcType().getJavaType().getName();
    }

    @Override
    public <T> T unwrap(Class<T> type) throws SQLException {
        if (this.isWrapperFor(type)) {
            return type.cast(this);
        }
        throw new SQLNonTransientException("SQLResultSetMetadata does not wrap " + type.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> type) throws SQLException {
        return type.isAssignableFrom(this.getClass());
    }

    @Override
    public void checkColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
            throw new SQLNonTransientException(String.format("Column index %d is out of range. Max index is %d", columnIndex, this.getColumnCount()), SQLStates.INVALID_PARAMETER_VALUE.getSqlState());
        }
    }

    @Override
    public boolean isTrimmable(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        return this.sqlMetadata.get(columnIndex - 1).getType().isTrimmable();
    }

    public String toString() {
        return "SQLResultSetMetaData{sqlMetadata=" + this.sqlMetadata + '}';
    }
}

