/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.tarantool.SqlProtoUtils;
import org.tarantool.jdbc.SQLBatchResultHolder;
import org.tarantool.jdbc.SQLConnection;
import org.tarantool.jdbc.SQLQueryHolder;
import org.tarantool.jdbc.SQLResultHolder;
import org.tarantool.jdbc.SQLResultSet;
import org.tarantool.jdbc.StatementTimeoutException;
import org.tarantool.jdbc.TarantoolConnection;
import org.tarantool.jdbc.TarantoolStatement;
import org.tarantool.jdbc.type.TarantoolSqlType;
import org.tarantool.util.JdbcConstants;
import org.tarantool.util.SQLStates;

public class SQLStatement
implements TarantoolStatement {
    private static final String GENERATED_KEY_COLUMN_NAME = "GENERATED_KEY";
    protected final TarantoolConnection connection;
    private final SQLResultSet emptyGeneratedKeys;
    protected SQLResultSet resultSet;
    protected int updateCount;
    protected SQLResultSet generatedKeys;
    private List<String> batchQueries = new ArrayList<String>();
    private boolean isCloseOnCompletion;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final int resultSetHoldability;
    private int maxRows;
    private int maxFieldSize;
    private long timeout;
    private boolean poolable;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);

    protected SQLStatement(SQLConnection sqlConnection) throws SQLException {
        this(sqlConnection, 1003, 1007, sqlConnection.getHoldability());
    }

    protected SQLStatement(SQLConnection sqlConnection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.connection = sqlConnection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.emptyGeneratedKeys = this.generatedKeys = this.executeGeneratedKeys(Collections.emptyList());
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkNotClosed();
        if (!this.executeInternal(2, sql, new Object[0])) {
            throw new SQLException("No results were returned", SQLStates.NO_DATA.getSqlState());
        }
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdate(sql, 2);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkNotClosed();
        JdbcConstants.checkGeneratedKeysConstant(autoGeneratedKeys);
        if (this.executeInternal(autoGeneratedKeys, sql, new Object[0])) {
            throw new SQLException("Result was returned but nothing was expected", SQLStates.TOO_MANY_RESULTS.getSqlState());
        }
        return this.updateCount;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed.compareAndSet(false, true)) {
            this.cancel();
            this.discardLastResults();
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int size) throws SQLException {
        if (size < 0) {
            throw new SQLException("The max field size must be positive or zero", SQLStates.INVALID_PARAMETER_VALUE.getSqlState());
        }
        this.maxFieldSize = size;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkNotClosed();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        this.checkNotClosed();
        if (maxRows < 0) {
            throw new SQLNonTransientException("Max rows parameter can't be a negative value");
        }
        this.maxRows = maxRows;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return (int)TimeUnit.MILLISECONDS.toSeconds(this.timeout);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw new SQLNonTransientException("Query timeout must be positive or zero", SQLStates.INVALID_PARAMETER_VALUE.getSqlState());
        }
        this.timeout = TimeUnit.SECONDS.toMillis(seconds);
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkNotClosed();
        return this.executeInternal(2, sql, new Object[0]);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkNotClosed();
        JdbcConstants.checkGeneratedKeysConstant(autoGeneratedKeys);
        return this.executeInternal(autoGeneratedKeys, sql, new Object[0]);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkNotClosed();
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkNotClosed();
        return this.updateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkNotClosed();
        JdbcConstants.checkCurrentResultConstant(current);
        if (this.resultSet != null && (current == 2 || current == 3)) {
            throw new SQLFeatureNotSupportedException();
        }
        this.discardLastResults();
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkNotClosed();
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkNotClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkNotClosed();
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkNotClosed();
        return this.resultSetType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkNotClosed();
        this.batchQueries.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkNotClosed();
        this.batchQueries.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkNotClosed();
        this.discardLastResults();
        try {
            List<SQLQueryHolder> queries = this.batchQueries.stream().map(q -> SQLQueryHolder.of(q, new Object[0])).collect(Collectors.toList());
            int[] nArray = this.executeBatchInternal(queries);
            return nArray;
        }
        finally {
            this.batchQueries.clear();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkNotClosed();
        return this.generatedKeys;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkNotClosed();
        return this.resultSetHoldability;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed.get() || this.connection.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkNotClosed();
        this.poolable = poolable;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkNotClosed();
        return this.poolable;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkNotClosed();
        this.isCloseOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkNotClosed();
        return this.isCloseOnCompletion;
    }

    @Override
    public void checkCompletion() throws SQLException {
        if (this.isCloseOnCompletion && this.resultSet != null && this.resultSet.isClosed()) {
            this.close();
        }
    }

    @Override
    public <T> T unwrap(Class<T> type) throws SQLException {
        if (this.isWrapperFor(type)) {
            return type.cast(this);
        }
        throw new SQLNonTransientException("SQLStatement does not wrap " + type.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> type) throws SQLException {
        return type.isAssignableFrom(this.getClass());
    }

    protected void discardLastResults() throws SQLException {
        SQLResultSet lastResultSet = this.resultSet;
        this.clearWarnings();
        this.updateCount = -1;
        this.resultSet = null;
        this.generatedKeys = this.emptyGeneratedKeys;
        if (lastResultSet != null) {
            try {
                lastResultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected boolean executeInternal(int autoGeneratedKeys, String sql, Object ... params) throws SQLException {
        SQLResultHolder holder;
        this.discardLastResults();
        try {
            holder = this.connection.execute(this.timeout, SQLQueryHolder.of(sql, params));
        }
        catch (StatementTimeoutException e) {
            this.cancel();
            throw new SQLTimeoutException();
        }
        if (holder.isQueryResult()) {
            this.resultSet = new SQLResultSet(holder, this);
        }
        this.updateCount = holder.getUpdateCount();
        if (autoGeneratedKeys == 1) {
            this.generatedKeys = this.executeGeneratedKeys(holder.getGeneratedIds());
        }
        return holder.isQueryResult();
    }

    protected int[] executeBatchInternal(List<SQLQueryHolder> queries) throws SQLException {
        SQLBatchResultHolder batchResult = this.connection.executeBatch(this.timeout, queries);
        int[] resultCounts = batchResult.getResults().stream().mapToInt(result -> result.isQueryResult() ? -3 : (result.getUpdateCount() == -1 ? -2 : result.getUpdateCount())).toArray();
        if (batchResult.getError() != null) {
            throw new BatchUpdateException(resultCounts, (Throwable)batchResult.getError());
        }
        return resultCounts;
    }

    @Override
    public ResultSet executeMetadata(SQLResultHolder data) throws SQLException {
        this.checkNotClosed();
        return this.createResultSet(data);
    }

    protected SQLResultSet createResultSet(SQLResultHolder holder) throws SQLException {
        return new SQLResultSet(holder, this);
    }

    protected void checkNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLNonTransientException("Statement is closed.");
        }
    }

    protected SQLResultSet executeGeneratedKeys(List<Integer> generatedKeys) throws SQLException {
        SqlProtoUtils.SQLMetaData sqlMetaData = new SqlProtoUtils.SQLMetaData(GENERATED_KEY_COLUMN_NAME, TarantoolSqlType.INTEGER);
        List<List<Object>> rows = generatedKeys.stream().map(Collections::singletonList).collect(Collectors.toList());
        return this.createResultSet(SQLResultHolder.ofQuery(Collections.singletonList(sqlMetaData), rows));
    }
}

