/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool.jdbc.cursor;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tarantool.jdbc.cursor.CursorIterator;
import org.tarantool.util.SQLStates;

public class InMemoryForwardCursorIteratorImpl
implements CursorIterator<List<Object>> {
    protected final List<List<Object>> results = new ArrayList<List<Object>>();
    protected int currentPosition = -1;

    public InMemoryForwardCursorIteratorImpl(List<List<Object>> results) {
        if (results == null) {
            throw new IllegalArgumentException("Results list cannot be null");
        }
        this.results.addAll(results);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.hasResults() && this.currentPosition == -1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.hasResults() && this.currentPosition == this.results.size();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.hasResults() && this.currentPosition == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.hasResults() && this.currentPosition == this.results.size() - 1;
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new SQLException("Cannot be called on forward only cursor", SQLStates.INVALID_CURSOR_STATE.getSqlState());
    }

    @Override
    public void afterLast() throws SQLException {
        throw new SQLException("Cannot be called on forward only cursor", SQLStates.INVALID_CURSOR_STATE.getSqlState());
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLException("Cannot be called on forward only cursor", SQLStates.INVALID_CURSOR_STATE.getSqlState());
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLException("Cannot be called on forward only cursor", SQLStates.INVALID_CURSOR_STATE.getSqlState());
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new SQLException("Cannot be called on forward only cursor", SQLStates.INVALID_CURSOR_STATE.getSqlState());
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new SQLException("Cannot be called on forward only cursor", SQLStates.INVALID_CURSOR_STATE.getSqlState());
    }

    @Override
    public boolean next() throws SQLException {
        if (!this.hasResults() || this.isAfterLast()) {
            return false;
        }
        ++this.currentPosition;
        return !this.isAfterLast();
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLException("Cannot be called on forward only cursor", SQLStates.INVALID_CURSOR_STATE.getSqlState());
    }

    @Override
    public int getRow() throws SQLException {
        return !this.hasResults() || this.isBeforeFirst() || this.isAfterLast() ? 0 : this.currentPosition + 1;
    }

    @Override
    public List<Object> getItem() throws SQLException {
        int row = this.getRow();
        if (row > 0) {
            return this.results.get(row - 1);
        }
        throw new SQLException("Cursor is out of range. Try to call next() or previous() before.", SQLStates.INVALID_CURSOR_STATE.getSqlState());
    }

    protected boolean hasResults() {
        return !this.results.isEmpty();
    }

    @Override
    public void close() {
        this.results.clear();
        this.currentPosition = -1;
    }
}

