/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool.jdbc.cursor;

import java.sql.SQLException;
import java.util.List;
import org.tarantool.jdbc.cursor.InMemoryForwardCursorIteratorImpl;

public class InMemoryScrollableCursorIteratorImpl
extends InMemoryForwardCursorIteratorImpl {
    public InMemoryScrollableCursorIteratorImpl(List<List<Object>> results) {
        super(results);
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.moveIfHasResults(-1);
    }

    @Override
    public void afterLast() throws SQLException {
        this.moveIfHasResults(this.results.size());
    }

    @Override
    public boolean first() throws SQLException {
        return this.moveIfHasResults(0);
    }

    @Override
    public boolean last() throws SQLException {
        return this.moveIfHasResults(this.results.size() - 1);
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (!this.hasResults()) {
            return false;
        }
        if (row == 0) {
            this.beforeFirst();
            return false;
        }
        if (row > this.results.size()) {
            this.afterLast();
            return false;
        }
        if (row < -this.results.size()) {
            this.beforeFirst();
            return false;
        }
        this.currentPosition = row > 0 ? row - 1 : this.results.size() + row;
        return true;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (!this.hasResults()) {
            return false;
        }
        if (rows == 0) {
            return !this.isBeforeFirst() && !this.isAfterLast();
        }
        if (this.currentPosition + rows >= this.results.size()) {
            this.afterLast();
            return false;
        }
        if (this.currentPosition + rows <= -1) {
            this.beforeFirst();
            return false;
        }
        return this.absolute(this.currentPosition + rows + 1);
    }

    @Override
    public boolean previous() throws SQLException {
        if (!this.hasResults() || this.isBeforeFirst()) {
            return false;
        }
        --this.currentPosition;
        return !this.isBeforeFirst();
    }

    private boolean moveIfHasResults(int position) {
        if (!this.hasResults()) {
            return false;
        }
        this.currentPosition = position;
        return true;
    }
}

