/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool.jdbc.ds;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.tarantool.jdbc.SQLConnection;
import org.tarantool.jdbc.SQLProperty;
import org.tarantool.jdbc.ds.TarantoolDataSource;

public class SQLDataSource
implements TarantoolDataSource,
DataSource {
    private PrintWriter logWriter;
    private String name = "Tarantool basic data source";
    private Properties properties = new Properties();

    @Override
    public Connection getConnection() throws SQLException {
        return new SQLConnection(this.makeUrl(), new Properties(this.properties));
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties copyProperties = new Properties(this.properties);
        SQLProperty.USER.setString(copyProperties, username);
        SQLProperty.PASSWORD.setString(copyProperties, password);
        return new SQLConnection(this.makeUrl(), copyProperties);
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        SQLProperty.LOGIN_TIMEOUT.setInt(this.properties, (int)TimeUnit.SECONDS.toMillis(seconds));
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return (int)TimeUnit.MILLISECONDS.toSeconds(SQLProperty.LOGIN_TIMEOUT.getInt(this.properties));
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> type) throws SQLException {
        if (this.isWrapperFor(type)) {
            return type.cast(this);
        }
        throw new SQLNonTransientException("SQLDataSource does not wrap " + type.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> type) {
        return type.isAssignableFrom(this.getClass());
    }

    @Override
    public String getServerName() {
        return SQLProperty.HOST.getString(this.properties);
    }

    @Override
    public void setServerName(String serverName) {
        SQLProperty.HOST.setString(this.properties, serverName);
    }

    @Override
    public int getPortNumber() throws SQLException {
        return SQLProperty.PORT.getInt(this.properties);
    }

    @Override
    public void setPortNumber(int port) {
        SQLProperty.PORT.setInt(this.properties, port);
    }

    @Override
    public String getUser() {
        return SQLProperty.USER.getString(this.properties);
    }

    @Override
    public void setUser(String userName) {
        SQLProperty.USER.setString(this.properties, userName);
    }

    @Override
    public String getPassword() {
        return SQLProperty.PASSWORD.getString(this.properties);
    }

    @Override
    public void setPassword(String password) {
        SQLProperty.PASSWORD.setString(this.properties, password);
    }

    @Override
    public String getDescription() {
        return "Basic DataSource implementation - produces a standard Connection object. Tarantool JDBC Driver.";
    }

    @Override
    public String getDataSourceName() {
        return this.name;
    }

    @Override
    public void setDataSourceName(String name) {
        this.name = name;
    }

    @Override
    public String getSocketChannelProvider() {
        return SQLProperty.SOCKET_CHANNEL_PROVIDER.getString(this.properties);
    }

    @Override
    public void setSocketChannelProvider(String classFqdn) {
        SQLProperty.SOCKET_CHANNEL_PROVIDER.setString(this.properties, classFqdn);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return (int)TimeUnit.MILLISECONDS.toSeconds(SQLProperty.QUERY_TIMEOUT.getInt(this.properties));
    }

    @Override
    public void setQueryTimeout(int seconds) {
        SQLProperty.QUERY_TIMEOUT.setInt(this.properties, (int)TimeUnit.SECONDS.toMillis(seconds));
    }

    private String makeUrl() {
        return "jdbc:tarantool://" + SQLProperty.HOST.getString(this.properties) + ":" + SQLProperty.PORT.getString(this.properties);
    }
}

