/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool.jdbc.type;

import java.util.HashMap;
import java.util.Map;
import org.tarantool.jdbc.type.JdbcType;
import org.tarantool.jdbc.type.TarantoolType;

public enum TarantoolSqlType {
    UNKNOWN(TarantoolType.UNKNOWN, JdbcType.UNKNOWN, "unknown"),
    FLOAT(TarantoolType.NUMBER, JdbcType.FLOAT, "float"),
    DOUBLE(TarantoolType.NUMBER, JdbcType.DOUBLE, "double"),
    REAL(TarantoolType.NUMBER, JdbcType.REAL, "real"),
    NUMBER(TarantoolType.NUMBER, JdbcType.DOUBLE, "number"),
    INT(TarantoolType.INTEGER, JdbcType.BIGINT, "int"),
    INTEGER(TarantoolType.INTEGER, JdbcType.BIGINT, "integer"),
    UNSIGNED(TarantoolType.UNSIGNED, JdbcType.BIGINT, "integer"),
    BOOL(TarantoolType.BOOLEAN, JdbcType.BOOLEAN, "bool"),
    BOOLEAN(TarantoolType.BOOLEAN, JdbcType.BOOLEAN, "boolean"),
    STRING(TarantoolType.STRING, JdbcType.VARCHAR, "string"),
    TEXT(TarantoolType.STRING, JdbcType.VARCHAR, "text"),
    VARCHAR(TarantoolType.STRING, JdbcType.VARCHAR, "varchar"){

        @Override
        public String getDisplayType() {
            return this.getTypeName() + "(128)";
        }
    }
    ,
    VARBINARY(TarantoolType.VARBINARY, JdbcType.VARBINARY, "varbinary"),
    SCALAR(TarantoolType.SCALAR, JdbcType.BINARY, "scalar");

    private static final Map<TarantoolType, TarantoolSqlType> defaultSqlTypeMapping;
    private final TarantoolType tarantoolType;
    private final JdbcType jdbcType;
    private final String typeName;

    public static TarantoolSqlType getDefaultSqlType(TarantoolType type) {
        return defaultSqlTypeMapping.getOrDefault((Object)type, UNKNOWN);
    }

    public static TarantoolSqlType of(String type) {
        for (TarantoolSqlType value : TarantoolSqlType.values()) {
            if (!value.typeName.equalsIgnoreCase(type)) continue;
            return value;
        }
        return UNKNOWN;
    }

    private TarantoolSqlType(TarantoolType tarantoolType, JdbcType jdbcType, String typeName) {
        this.tarantoolType = tarantoolType;
        this.jdbcType = jdbcType;
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDisplayType() {
        return this.typeName;
    }

    public TarantoolType getTarantoolType() {
        return this.tarantoolType;
    }

    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    public boolean isSigned() {
        return this.tarantoolType.isSigned();
    }

    public boolean isCaseSensitive() {
        return this.tarantoolType.isCaseSensitive();
    }

    public boolean isTrimmable() {
        return this.jdbcType.isTrimmable();
    }

    public int getPrecision() {
        return this.tarantoolType.getPrecision();
    }

    public int getScale() {
        return this.tarantoolType.getScale();
    }

    public int getDisplaySize() {
        return this.tarantoolType.getDisplaySize();
    }

    public String toString() {
        return "TarantoolSqlType{tarantoolType=" + (Object)((Object)this.tarantoolType) + ", jdbcType=" + (Object)((Object)this.jdbcType) + ", typeName='" + this.typeName + '\'' + '}';
    }

    static {
        defaultSqlTypeMapping = new HashMap<TarantoolType, TarantoolSqlType>();
        defaultSqlTypeMapping.put(TarantoolType.BOOLEAN, BOOLEAN);
        defaultSqlTypeMapping.put(TarantoolType.STRING, STRING);
        defaultSqlTypeMapping.put(TarantoolType.INTEGER, INTEGER);
        defaultSqlTypeMapping.put(TarantoolType.UNSIGNED, UNSIGNED);
        defaultSqlTypeMapping.put(TarantoolType.NUMBER, NUMBER);
        defaultSqlTypeMapping.put(TarantoolType.VARBINARY, VARBINARY);
        defaultSqlTypeMapping.put(TarantoolType.SCALAR, SCALAR);
    }
}

