/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool.jdbc.type;

public enum TarantoolType {
    UNKNOWN("unknown", false, false, 0, 0, 0),
    BOOLEAN("boolean", false, false, 1, 0, 5),
    STRING("string", false, true, Integer.MAX_VALUE, 0, Integer.MAX_VALUE),
    INTEGER("integer", true, false, 20, 0, 20),
    UNSIGNED("unsigned", false, false, 20, 0, 20),
    NUMBER("number", true, false, 20, 16, 24),
    SCALAR("scalar", false, true, Integer.MAX_VALUE, 0, Integer.MAX_VALUE),
    VARBINARY("varbinary", false, true, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);

    private final String typeName;
    private final boolean signed;
    private final boolean caseSensitive;
    private final int precision;
    private final int scale;
    private final int displaySize;

    public static TarantoolType of(String type) {
        for (TarantoolType value : TarantoolType.values()) {
            if (!value.typeName.equalsIgnoreCase(type)) continue;
            return value;
        }
        return UNKNOWN;
    }

    private TarantoolType(String typeName, boolean signed, boolean caseSensitive, int precision, int scale, int displaySize) {
        this.typeName = typeName;
        this.signed = signed;
        this.caseSensitive = caseSensitive;
        this.precision = precision;
        this.scale = scale;
        this.displaySize = displaySize;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public int getDisplaySize() {
        return this.displaySize;
    }

    public String toString() {
        return "TarantoolType{typeName='" + this.typeName + '\'' + ", signed=" + this.signed + ", caseSensitive=" + this.caseSensitive + ", precision=" + this.precision + ", scale=" + this.scale + ", displaySize=" + this.displaySize + '}';
    }
}

