/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool.logging;

import java.util.function.Supplier;
import org.tarantool.logging.Logger;

abstract class BaseLogger
implements Logger {
    BaseLogger() {
    }

    public abstract void log(Logger.Level var1, String var2, Throwable var3, Object ... var4);

    public void log(Logger.Level level, Throwable error, Supplier<String> message) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.log(level, message.get(), error, new Object[0]);
    }

    public abstract boolean isLoggable(Logger.Level var1);

    @Override
    public void debug(String message) {
        this.log(Logger.Level.DEBUG, message, null, new Object[0]);
    }

    @Override
    public void debug(String format, Object ... params) {
        this.log(Logger.Level.DEBUG, format, null, params);
    }

    @Override
    public void debug(String message, Throwable throwable) {
        this.log(Logger.Level.DEBUG, message, throwable, new Object[0]);
    }

    @Override
    public void debug(Supplier<String> message, Throwable throwable) {
        this.log(Logger.Level.DEBUG, throwable, message);
    }

    @Override
    public void error(String message) {
        this.log(Logger.Level.ERROR, message, null, new Object[0]);
    }

    @Override
    public void error(String format, Object ... params) {
        this.log(Logger.Level.ERROR, format, null, params);
    }

    @Override
    public void error(String message, Throwable throwable) {
        this.log(Logger.Level.ERROR, message, throwable, new Object[0]);
    }

    @Override
    public void error(Supplier<String> message, Throwable throwable) {
        this.log(Logger.Level.ERROR, throwable, message);
    }

    @Override
    public void info(String message) {
        this.log(Logger.Level.INFO, message, null, new Object[0]);
    }

    @Override
    public void info(String format, Object ... params) {
        this.log(Logger.Level.INFO, format, null, params);
    }

    @Override
    public void info(String message, Throwable throwable) {
        this.log(Logger.Level.INFO, message, throwable, new Object[0]);
    }

    @Override
    public void info(Supplier<String> message, Throwable throwable) {
        this.log(Logger.Level.INFO, throwable, message);
    }

    @Override
    public void trace(String message) {
        this.log(Logger.Level.TRACE, message, null, new Object[0]);
    }

    @Override
    public void trace(String format, Object ... params) {
        this.log(Logger.Level.TRACE, format, null, params);
    }

    @Override
    public void trace(String message, Throwable throwable) {
        this.log(Logger.Level.TRACE, message, throwable, new Object[0]);
    }

    @Override
    public void trace(Supplier<String> message, Throwable throwable) {
        this.log(Logger.Level.TRACE, throwable, message);
    }

    @Override
    public void warn(String message) {
        this.log(Logger.Level.WARN, message, null, new Object[0]);
    }

    @Override
    public void warn(String format, Object ... params) {
        this.log(Logger.Level.WARN, format, null, params);
    }

    @Override
    public void warn(String message, Throwable throwable) {
        this.log(Logger.Level.WARN, message, throwable, new Object[0]);
    }

    @Override
    public void warn(Supplier<String> message, Throwable throwable) {
        this.log(Logger.Level.WARN, throwable, message);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isLoggable(Logger.Level.DEBUG);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isLoggable(Logger.Level.ERROR);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isLoggable(Logger.Level.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isLoggable(Logger.Level.TRACE);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isLoggable(Logger.Level.WARN);
    }
}

