/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.tarantool.logging.BaseLogger;
import org.tarantool.logging.Logger;

class JdkLogger
extends BaseLogger {
    private final Logger delegate;

    public JdkLogger(String loggerName) {
        this.delegate = Logger.getLogger(loggerName);
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public void log(Logger.Level level, String text, Throwable error, Object ... parameters) {
        if (!this.isLoggable(level)) {
            return;
        }
        Level julLevel = this.translate(level);
        LogRecord record = new LogRecord(julLevel, text);
        record.setLoggerName(this.delegate.getName());
        record.setResourceBundle(this.delegate.getResourceBundle());
        record.setResourceBundleName(this.delegate.getResourceBundleName());
        if (error != null) {
            record.setThrown(error);
        }
        record.setParameters(parameters);
        this.delegate.log(record);
    }

    @Override
    public boolean isLoggable(Logger.Level level) {
        return this.delegate.isLoggable(this.translate(level));
    }

    private Level translate(Logger.Level level) {
        switch (level) {
            case ERROR: {
                return Level.SEVERE;
            }
            case WARN: {
                return Level.WARNING;
            }
            case INFO: {
                return Level.INFO;
            }
            case DEBUG: {
                return Level.FINE;
            }
            case TRACE: {
                return Level.FINEST;
            }
        }
        return Level.ALL;
    }
}

