/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool.logging;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.tarantool.logging.JdkLoggerProvider;
import org.tarantool.logging.Logger;
import org.tarantool.logging.LoggerProvider;
import org.tarantool.logging.Slf4jLoggerProvider;

public class LoggerFactory {
    private static final String LOGGING_PROVIDER_KEY = "org.tarantool.logging.provider";
    private static final String LOGGING_PROVIDER_JDK = "jdk";
    private static final String LOGGING_PROVIDER_SLF4J = "slf4j";
    private static LoggerProvider loggerProvider = LoggerFactory.loadLoggerProvider();

    private static LoggerProvider loadLoggerProvider() {
        try {
            String providerName = System.getProperty(LOGGING_PROVIDER_KEY);
            if (providerName != null) {
                if (providerName.equalsIgnoreCase(LOGGING_PROVIDER_JDK)) {
                    return LoggerFactory.tryLoadJdkProvider();
                }
                if (providerName.equalsIgnoreCase(LOGGING_PROVIDER_SLF4J)) {
                    return LoggerFactory.tryLoadSlf4jProvider();
                }
            }
        }
        catch (Throwable providerName) {
            // empty catch block
        }
        try {
            ServiceLoader<LoggerProvider> serviceLoader = ServiceLoader.load(LoggerProvider.class);
            Iterator<LoggerProvider> iterator = serviceLoader.iterator();
            while (loggerProvider == null && iterator.hasNext()) {
                try {
                    return iterator.next();
                }
                catch (Throwable throwable) {
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Class.forName("ch.qos.logback.classic.Logger", false, LoggerFactory.class.getClassLoader());
            return LoggerFactory.tryLoadSlf4jProvider();
        }
        catch (Throwable throwable) {
            return LoggerFactory.tryLoadJdkProvider();
        }
    }

    private static LoggerProvider tryLoadJdkProvider() {
        return new JdkLoggerProvider();
    }

    private static LoggerProvider tryLoadSlf4jProvider() {
        return new Slf4jLoggerProvider();
    }

    private LoggerFactory() {
    }

    public static Logger getLogger(String name) {
        return loggerProvider.getLogger(name);
    }

    public static Logger getLogger(Class<?> type) {
        return loggerProvider.getLogger(type.getName());
    }
}

