/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool.logging;

import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tarantool.logging.BaseLogger;
import org.tarantool.logging.Logger;

class Slf4jLogger
extends BaseLogger {
    private final Logger delegate;

    public Slf4jLogger(String loggerName) {
        this.delegate = LoggerFactory.getLogger((String)loggerName);
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public void log(Logger.Level level, String text, Throwable error, Object ... parameters) {
        if (!this.isLoggable(level)) {
            return;
        }
        String message = parameters == null || parameters.length == 0 ? text : MessageFormat.format(text, parameters);
        switch (level) {
            case ERROR: {
                this.delegate.error(message, error);
                break;
            }
            case WARN: {
                this.delegate.warn(message, error);
                break;
            }
            case INFO: {
                this.delegate.info(message, error);
                break;
            }
            case DEBUG: {
                this.delegate.debug(message, error);
                break;
            }
            case TRACE: {
                this.delegate.trace(message, error);
                break;
            }
        }
    }

    @Override
    public boolean isLoggable(Logger.Level level) {
        switch (level) {
            case ERROR: {
                return this.delegate.isErrorEnabled();
            }
            case WARN: {
                return this.delegate.isWarnEnabled();
            }
            case INFO: {
                return this.delegate.isInfoEnabled();
            }
            case DEBUG: {
                return this.delegate.isDebugEnabled();
            }
            case TRACE: {
                return this.delegate.isTraceEnabled();
            }
        }
        return true;
    }
}

