/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool.protocol;

import java.io.InputStream;
import java.nio.ByteBuffer;

class ByteBufferBackedInputStream
extends InputStream {
    private final ByteBuffer buf;

    public ByteBufferBackedInputStream(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public int read() {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        return this.buf.get() & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int off, int len) {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        len = Math.min(len, this.buf.remaining());
        this.buf.get(bytes, off, len);
        return len;
    }

    @Override
    public int available() {
        return this.buf.remaining();
    }

    public boolean hasAvailable() {
        return this.available() > 0;
    }
}

