/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool.protocol;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import org.tarantool.Base64;
import org.tarantool.Code;
import org.tarantool.CommunicationException;
import org.tarantool.CountInputStreamImpl;
import org.tarantool.Key;
import org.tarantool.MsgPackLite;
import org.tarantool.TarantoolException;
import org.tarantool.protocol.ByteBufferBackedInputStream;
import org.tarantool.protocol.TarantoolGreeting;
import org.tarantool.protocol.TarantoolPacket;

public abstract class ProtoUtils {
    public static final int LENGTH_OF_SIZE_MESSAGE = 5;
    private static final int DEFAULT_INITIAL_REQUEST_SIZE = 4096;
    private static final String WELCOME = "Tarantool ";

    public static TarantoolPacket readPacket(InputStream inputStream, MsgPackLite msgPackLite) throws IOException {
        CountInputStreamImpl msgStream = new CountInputStreamImpl(inputStream);
        int size = ((Number)msgPackLite.unpack(msgStream)).intValue();
        long mark = msgStream.getBytesRead();
        Map headers = (Map)msgPackLite.unpack(msgStream);
        Map body = null;
        if (msgStream.getBytesRead() - mark < (long)size) {
            body = (Map)msgPackLite.unpack(msgStream);
        }
        return new TarantoolPacket(headers, body);
    }

    public static TarantoolPacket readPacket(ReadableByteChannel bufferReader, MsgPackLite msgPackLite) throws CommunicationException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(5);
        bufferReader.read(buffer);
        buffer.flip();
        int size = ((Number)msgPackLite.unpack(new ByteBufferBackedInputStream(buffer))).intValue();
        buffer = ByteBuffer.allocate(size);
        bufferReader.read(buffer);
        buffer.flip();
        ByteBufferBackedInputStream msgBytesStream = new ByteBufferBackedInputStream(buffer);
        Object unpackedHeaders = msgPackLite.unpack(msgBytesStream);
        if (!(unpackedHeaders instanceof Map)) {
            throw new CommunicationException("Error while unpacking headers of tarantool response: expected type Map but was " + unpackedHeaders != null ? unpackedHeaders.getClass().toString() : "null");
        }
        Map headers = (Map)unpackedHeaders;
        Map body = null;
        if (msgBytesStream.hasAvailable()) {
            Object unpackedBody = msgPackLite.unpack(msgBytesStream);
            if (!(unpackedBody instanceof Map)) {
                throw new CommunicationException("Error while unpacking body of tarantool response: expected type Map but was " + unpackedBody != null ? unpackedBody.getClass().toString() : "null");
            }
            body = (Map)unpackedBody;
        }
        return new TarantoolPacket(headers, body);
    }

    public static TarantoolGreeting connect(Socket socket, String username, String password, MsgPackLite msgPackLite) throws IOException {
        byte[] inputBytes = new byte[64];
        InputStream inputStream = socket.getInputStream();
        inputStream.read(inputBytes);
        String firstLine = new String(inputBytes);
        ProtoUtils.assertCorrectWelcome(firstLine, socket.getRemoteSocketAddress());
        String serverVersion = firstLine.substring(WELCOME.length());
        inputStream.read(inputBytes);
        String salt = new String(inputBytes);
        if (username != null && password != null) {
            ByteBuffer authPacket = ProtoUtils.createAuthPacket(username, password, salt, msgPackLite);
            OutputStream os = socket.getOutputStream();
            os.write(authPacket.array(), 0, authPacket.remaining());
            os.flush();
            TarantoolPacket responsePacket = ProtoUtils.readPacket(socket.getInputStream(), msgPackLite);
            ProtoUtils.assertNoErrCode(responsePacket);
        }
        return new TarantoolGreeting(serverVersion);
    }

    public static TarantoolGreeting connect(SocketChannel channel, String username, String password, MsgPackLite msgPackLite) throws IOException {
        ByteBuffer welcomeBytes = ByteBuffer.wrap(new byte[64]);
        channel.read(welcomeBytes);
        String firstLine = new String(welcomeBytes.array());
        ProtoUtils.assertCorrectWelcome(firstLine, channel.getRemoteAddress());
        String serverVersion = firstLine.substring(WELCOME.length());
        ((Buffer)welcomeBytes).clear();
        channel.read(welcomeBytes);
        String salt = new String(welcomeBytes.array());
        if (username != null && password != null) {
            ByteBuffer authPacket = ProtoUtils.createAuthPacket(username, password, salt, msgPackLite);
            ProtoUtils.writeFully(channel, authPacket);
            TarantoolPacket authResponse = ProtoUtils.readPacket(channel, msgPackLite);
            ProtoUtils.assertNoErrCode(authResponse);
        }
        return new TarantoolGreeting(serverVersion);
    }

    private static void assertCorrectWelcome(String firstLine, SocketAddress remoteAddress) {
        if (!firstLine.startsWith(WELCOME)) {
            String errMsg = "Failed to connect to node " + remoteAddress.toString() + ": Welcome message should starts with tarantool but starts with '" + firstLine + "'";
            throw new CommunicationException(errMsg, new IllegalStateException("Invalid welcome packet"));
        }
    }

    private static void assertNoErrCode(TarantoolPacket authResponse) {
        Long code = (Long)authResponse.getHeaders().get(Key.CODE.getId());
        if (code != 0L) {
            Object error = authResponse.getError();
            String errorMsg = error instanceof String ? (String)error : new String((byte[])error);
            throw new TarantoolException(code, errorMsg);
        }
    }

    public static void writeFully(OutputStream stream, ByteBuffer buffer) throws IOException {
        stream.write(buffer.array());
        stream.flush();
    }

    public static void writeFully(SocketChannel channel, ByteBuffer buffer) throws IOException {
        long code = 0L;
        while (buffer.remaining() > 0 && (code = (long)channel.write(buffer)) > -1L) {
        }
        if (code < 0L) {
            throw new SocketException("write failed code: " + code);
        }
    }

    public static ByteBuffer createAuthPacket(String username, String password, String salt, MsgPackLite msgPackLite) throws IOException {
        MessageDigest sha1;
        try {
            sha1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        ArrayList<Object> auth = new ArrayList<Object>(2);
        auth.add("chap-sha1");
        byte[] p = sha1.digest(password.getBytes());
        sha1.reset();
        byte[] p2 = sha1.digest(p);
        sha1.reset();
        sha1.update(Base64.decode(salt), 0, 20);
        sha1.update(p2);
        byte[] scramble = sha1.digest();
        int e = 20;
        for (int i = 0; i < e; ++i) {
            int n = i;
            p[n] = (byte)(p[n] ^ scramble[i]);
        }
        auth.add(p);
        return ProtoUtils.createPacket(4096, msgPackLite, Code.AUTH, (Long)0L, null, Key.USER_NAME, username, Key.TUPLE, auth);
    }

    public static ByteBuffer createPacket(MsgPackLite msgPackLite, Code code, Long syncId, Long schemaId, Object ... args) throws IOException {
        return ProtoUtils.createPacket(4096, msgPackLite, code, syncId, schemaId, args);
    }

    public static ByteBuffer createPacket(int initialRequestSize, MsgPackLite msgPackLite, Code code, Long syncId, Long schemaId, Object ... args) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(initialRequestSize);
        bos.write(new byte[5]);
        DataOutputStream ds = new DataOutputStream(bos);
        EnumMap<Key, Object> header = new EnumMap<Key, Object>(Key.class);
        EnumMap<Key, Object> body = new EnumMap<Key, Object>(Key.class);
        header.put(Key.CODE, (Object)code);
        header.put(Key.SYNC, syncId);
        if (schemaId != null) {
            header.put(Key.SCHEMA_ID, schemaId);
        }
        if (args != null) {
            int e = args.length;
            for (int i = 0; i < e; i += 2) {
                Object value = args[i + 1];
                body.put((Key)args[i], value);
            }
        }
        msgPackLite.pack(header, ds);
        msgPackLite.pack(body, ds);
        ds.flush();
        ByteBuffer buffer = bos.toByteBuffer();
        buffer.put(0, (byte)-50);
        buffer.putInt(1, bos.size() - 5);
        return buffer;
    }

    public static long extractErrorCode(long code) {
        if ((code & 0x8000L) == 0L) {
            throw new IllegalArgumentException(String.format("Code %h does not follow 0x8XXX format", code));
        }
        return 0xFFFFFFFFFFFF7FFFL & code;
    }

    private static class ByteArrayOutputStream
    extends java.io.ByteArrayOutputStream {
        public ByteArrayOutputStream(int size) {
            super(size);
        }

        ByteBuffer toByteBuffer() {
            return ByteBuffer.wrap(this.buf, 0, this.count);
        }
    }
}

