/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool.protocol;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import org.tarantool.CommunicationException;

public class ReadableViaSelectorChannel
implements ReadableByteChannel {
    private final SocketChannel channel;
    private final Selector selector;

    public ReadableViaSelectorChannel(SocketChannel channel) throws IOException {
        if (channel.isBlocking()) {
            throw new IllegalArgumentException("Channel have to be non-blocking");
        }
        this.channel = channel;
        this.selector = SelectorProvider.provider().openSelector();
        channel.register(this.selector, 1);
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        int n;
        int count = n = this.channel.read(buffer);
        if (n < 0) {
            throw new CommunicationException("Channel read failed " + this.formatReadBytes(n));
        }
        while (buffer.remaining() > 0) {
            this.selector.select();
            n = this.channel.read(buffer);
            if (n < 0) {
                throw new CommunicationException("Channel read failed: " + this.formatReadBytes(n));
            }
            count += n;
        }
        return count;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.selector.close();
        this.channel.close();
    }

    private String formatReadBytes(int bytes) {
        return bytes < 0 ? "EOF" : bytes + " bytes";
    }
}

